/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.items;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.menu.EditableMenuBuilder;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.items.ItemGroup;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.menus.MenuManager;
import io.lumine.mythic.core.menus.MythicMenu;
import io.lumine.mythic.core.menus.items.ItemBrowseMode;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import io.lumine.mythic.core.menus.items.ItemMenuContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ItemBrowseMenu
extends MythicMenu<ItemMenuContext> {
    public ItemBrowseMenu(MythicBukkit plugin, MenuManager manager) {
        super(plugin, manager, "/menus/item-browser.yml");
    }

    public void open(Player player) {
        this.open(player, new ItemMenuContext());
    }

    @Override
    public void open(Player player, ItemMenuContext context) {
        if (context.getMode() == ItemBrowseMode.PACKS && context.getPackFilter() == null) {
            ArrayList data = Lists.newArrayList();
            for (Pack pack : this.getPlugin().getPackManager().getPacks()) {
                data.add(() -> pack.createMenuIcon((pContext, pPlayer) -> {
                    pContext.setPackFilter(pack);
                    this.open((Player)pPlayer, (ItemMenuContext)pContext);
                }));
            }
            this.getPlugin().getMenuManager().getItemBrowseMenu().open(player, context, data);
        } else if (context.getMode() == ItemBrowseMode.GROUPS && context.getGroupFilter() == null) {
            ArrayList data = Lists.newArrayList();
            for (ItemGroup group : this.getPlugin().getItemManager().getItemGroups()) {
                data.add(() -> IconBuilder.create().item(group.getMenuItem()).name(group.getName()).click((pContext, pPlayer) -> {
                    pContext.setGroupFilter(group);
                    this.open((Player)pPlayer, (ItemMenuContext)pContext);
                }).build());
            }
            this.getPlugin().getMenuManager().getItemBrowseMenu().open(player, context, data);
        } else {
            ArrayList items = Lists.newArrayList(this.getPlugin().getItemManager().getItems());
            if (context.hasPackFilter()) {
                items.removeIf(mi -> mi.getPack() == null || mi.getPack() != context.getPackFilter());
            } else if (context.hasGroupFilter()) {
                items.removeIf(mi -> mi.getGroup() == null || !mi.getGroup().equalsIgnoreCase(context.getGroupFilter().getId()));
            }
            if (context.hasFilter()) {
                this.getPlugin().getItemManager().filterItems(items, context.getFilter());
            }
            Collections.sort(items, (i1, i2) -> i1.getInternalName().compareToIgnoreCase(i2.getInternalName()));
            this.getPlugin().getMenuManager().getItemBrowseMenu().open(player, context, items);
        }
    }

    @Override
    public EditableMenuBuilder<ItemMenuContext> build(EditableMenuBuilder<ItemMenuContext> builder) {
        builder = this.addPageButtons(builder);
        builder.getIcon("BACK_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            if (context.getMode() == ItemBrowseMode.PACKS && context.hasPackFilter()) {
                context.clearPackFilter();
                this.open((Player)player, (ItemMenuContext)context);
            } else if (context.getMode() == ItemBrowseMode.GROUPS && context.hasGroupFilter()) {
                context.clearGroupFilter();
                this.open((Player)player, (ItemMenuContext)context);
            } else {
                this.getMenuManager().getMainMenu().open((Player)player, player);
            }
        }));
        builder.getIcon("VIEW_BUTTON").ifPresent(icon -> icon.getBuilder().lore(context -> Lists.newArrayList((Object[])new String[]{"<gold>Current View<white>: <yellow>" + context.getMode()})).click((context, player) -> {
            context.clearPackFilter();
            context.clearGroupFilter();
            context.setMode(context.getMode().next());
            this.open((Player)player, (ItemMenuContext)context);
        }));
        builder.getIcon("FILTER_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            player.closeInventory();
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the text you'd like to search for:", "<gray>Type cancel to abort filtering.");
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                context.setFilter(input);
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> this.open((Player)player, (ItemMenuContext)context));
        }));
        builder.getIcon("FILTER_RESET_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            context.clearFilter();
            this.open((Player)player, (ItemMenuContext)context);
        }));
        builder.getIcon("CREATE_BUTTON").ifPresent(icon -> icon.getBuilder().click((context, player) -> {
            player.closeInventory();
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the item name in one of the following ways:", "<yellow>- &6[item_name]", "<yellow>- &3<pack>&7.&6[item_name] &3<path_to_file>", "<gray>Type cancel to abort editing.");
            ChatPrompt.listen(player, input -> {
                String[] split2;
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                String packName = null;
                Object filePath = null;
                String[] split1 = input.split(" ");
                if (split1.length > 1) {
                    input = split1[0];
                    filePath = split1[1];
                }
                if ((split2 = input.split("\\.")).length > 1) {
                    packName = split2[0];
                    input = split2[1];
                }
                String name = input;
                if (filePath == null) {
                    filePath = name.toLowerCase() + ".yml";
                } else if (!((String)filePath).endsWith(".yml")) {
                    filePath = (String)filePath + ".yml";
                }
                if (((String)filePath).contains("..")) {
                    CommandHelper.sendError((CommandSender)player, "Invalid file path");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                Optional<Pack> maybePack = this.getPlugin().getPackManager().getPack(packName);
                if (maybePack.isEmpty()) {
                    CommandHelper.sendError((CommandSender)player, "Invalid pack specified: not found");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                Pack pack = maybePack.get();
                File file = new File(pack.getFolder(), "Items/" + (String)filePath);
                if (!file.exists()) {
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().exists()) {
                        CommandHelper.sendError((CommandSender)player, "Failed to create file: see console for errors C");
                        return ChatPrompt.Response.TRY_AGAIN;
                    }
                    try {
                        if (!file.createNewFile()) {
                            CommandHelper.sendError((CommandSender)player, "Failed to create file: see console for errors A");
                            return ChatPrompt.Response.TRY_AGAIN;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        CommandHelper.sendError((CommandSender)player, "Failed to create file: see console for errors B");
                        return ChatPrompt.Response.TRY_AGAIN;
                    }
                }
                MythicItem newItem = new MythicItem(pack, file, name);
                this.getPlugin().getItemManager().registerItem(name, newItem);
                CommandHelper.sendSuccess((CommandSender)player, "Created new item " + name + "...");
                ItemEditorMenuContext ctx = new ItemEditorMenuContext(newItem, (ItemMenuContext)context);
                Schedulers.sync().run(() -> this.getPlugin().getMenuManager().getItemEditorMenu().open((Player)player, ctx));
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> {
                if (in.getResponse().equalsIgnoreCase("cancel")) {
                    context.openMenu((Player)player);
                    return;
                }
            });
        }));
        return builder;
    }
}

