/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.items.editor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.commands.items.edit.ItemEditCommand;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.IconBuilder;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.menus.items.ItemEditorButton;
import io.lumine.mythic.core.menus.items.ItemEditorButtons;
import io.lumine.mythic.core.menus.items.ItemEditorMenuContext;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythiccrucible.items.CrucibleItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EditStatsButton
extends ItemEditorButton {
    public EditStatsButton(ItemEditorButtons parent, int sort) {
        super(parent, sort);
    }

    @Override
    public Icon<ItemEditorMenuContext> getIcon() {
        return IconBuilder.create().material(Material.ENDER_EYE).name("<green>Edit Stats").lore(context -> {
            ArrayList lore = Lists.newArrayList();
            if (MythicBukkit.inst().getCompatibility().getCrucible().isEmpty()) {
                lore.add("<red>[Requires MythicCrucible Add-on]");
                lore.add("<red> ");
            }
            lore.add("<white>Left-click add a stat");
            lore.add("<white>Right-click to edit stats");
            lore.add("<red>");
            lore.add("<yellow>Current:");
            lore.add("<red>");
            MythicItem item = context.getItem();
            CrucibleItem crucibleItem = MythicBukkit.inst().getCompatibility().getCrucible().get().getCrucibleItem(item.getInternalName()).get();
            lore.addAll(EditStatsButton.getItemStats(crucibleItem));
            return lore;
        }).click((context, player) -> {
            if (MythicBukkit.inst().getCompatibility().getCrucible().isEmpty()) {
                CommandHelper.sendError((CommandSender)player, "This feature requires the MythicCrucible add-on");
                player.playSound((Entity)player, "entity.villager.no", 1.0f, 1.0f);
                return;
            }
            CommandHelper.sendEditorMessage((CommandSender)player, "Type in the stat you'd like to add.", "Format: [amount] [stat_name] <ADDITIVE/MULTIPLY/COMPOUND>", "Type <yellow>cancel to abort editing or <yellow>list to list stats.");
            player.closeInventory();
            ChatPrompt.listen(player, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                if (input.equalsIgnoreCase("list")) {
                    ArrayList sortedStats = Lists.newArrayList(MythicBukkit.inst().getStatManager().getStats().keySet());
                    Collections.sort(sortedStats);
                    for (String stat : sortedStats) {
                        CommandHelper.send((CommandSender)player, "\u27f6 " + stat);
                    }
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                MythicItem item = context.getItem();
                CrucibleItem crucibleItem = MythicBukkit.inst().getCompatibility().getCrucible().get().getCrucibleItem(item.getInternalName()).get();
                String[] split = input.split(" ");
                try {
                    PlaceholderDouble amount = PlaceholderDouble.of(split[0]);
                    Log.info("amount {0} {1}", split[0], amount.get());
                    Optional<StatType> maybeStat = MythicBukkit.inst().getStatManager().getStat(split[1]);
                    if (maybeStat.isEmpty()) {
                        CommandHelper.sendError((CommandSender)player, "Stat '" + split[1] + "' not found. Make sure it's registered in stats.yml!");
                        return ChatPrompt.Response.TRY_AGAIN;
                    }
                    StatType stat = maybeStat.get();
                    StatModifierType modifierType = StatModifierType.ADDITIVE;
                    if (split.length > 2) {
                        modifierType = StatModifierType.get(split[2]);
                    }
                    Map statMap = crucibleItem.getStats().computeIfAbsent(stat.getKey(), s2 -> Maps.newHashMap());
                    statMap.put(modifierType, amount);
                    EditStatsButton.saveItemStats(crucibleItem);
                }
                catch (Throwable ex) {
                    CommandHelper.sendError((CommandSender)player, "Format: [amount] [stat_name] <ADDITIVE/MULTIPLICATIVE/COMPOUND>");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> context.openMenu((Player)player));
        }).rightClick((context, player) -> {
            ItemEditCommand.lastEdited.put(player.getUniqueId(), (ItemEditorMenuContext)context);
            player.performCommand("mm i edit stats " + context.getItem().getInternalName());
            player.closeInventory();
        }).build();
    }

    public static List<String> getItemStats(CrucibleItem item) {
        ArrayList saveList = Lists.newArrayList();
        for (Map.Entry entry : item.getStats().entrySet()) {
            String stat = ((String)entry.getKey()).toUpperCase();
            Map valueMap = (Map)entry.getValue();
            for (Map.Entry opEntry : valueMap.entrySet()) {
                StatModifierType operation = (StatModifierType)((Object)opEntry.getKey());
                String value = ((PlaceholderDouble)opEntry.getValue()).serialize();
                saveList.add(value + " " + stat + " " + operation);
            }
        }
        return saveList;
    }

    public static void saveItemStats(CrucibleItem item) {
        List<String> saveList = EditStatsButton.getItemStats(item);
        item.getConfig().setSave("Stats", saveList);
        item.getMythicItem().buildItemCache();
    }
}

