/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.bukkit.utils.numbers.RangedInt;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Ashijin", name="targets", aliases={}, description="Tests if the number of inherited targets from the parent skilltree matches the given range.")
public class TargetsCondition
extends SkillCondition
implements ISkillMetaCondition {
    @MythicField(name="amount", aliases={"a"}, description="Range of how many targets to check for", defValue=">0")
    private RangedInt amount;

    public TargetsCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.amount = new RangedInt(mlc.getString(new String[]{"amount", "a"}, this.conditionVar, ">0"));
    }

    @Override
    public boolean check(SkillMetadata meta) {
        if (meta.getEntityTargets() != null) {
            return this.amount.equals(meta.getEntityTargets().size());
        }
        if (meta.getLocationTargets() != null) {
            return this.amount.equals(meta.getLocationTargets().size());
        }
        return false;
    }
}

