/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.bukkit.block.Block;

@MythicCondition(author="Ashijin", name="triggerBlockType", aliases={"triggeringBlockType"}, description="Tests the material type that triggered the skill")
public class TriggerBlockTypeCondition
extends SkillCondition
implements ISkillMetaCondition {
    @MythicField(name="types", aliases={"types", "type", "t", "material", "mat", "m"}, description="A list of materials to check")
    private Collection<AbstractBlock> types = Sets.newHashSet();

    public TriggerBlockTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        TriggerBlockTypeCondition.getPlugin().getClock().queuePostReload(() -> {
            List<String> b = mlc.getStringList(new String[]{"types", "type", "t", "material", "mat", "m"}, "DIRT", this.conditionVar);
            for (String s2 : b) {
                AbstractBlock block = TriggerBlockTypeCondition.getPlugin().getBootstrap().getBlock(s2);
                if (block instanceof AbstractBlock.InvalidBlock) {
                    MythicLogger.errorConditionConfig(this, mlc, "'" + s2 + "' is not a valid block type.");
                    return;
                }
                this.types.add(block);
            }
        });
    }

    @Override
    public boolean check(SkillMetadata meta) {
        Optional<Object> maybe = meta.getMetadata("block");
        if (maybe.isPresent()) {
            Block block = (Block)maybe.get();
            AbstractLocation location = BukkitAdapter.adapt(block.getLocation());
            for (AbstractBlock type : this.types) {
                if (!type.matches(location)) continue;
                return true;
            }
        }
        return false;
    }
}

