/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.volatilecode.VolatileMaterial;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;

@MythicMechanic(author="Ashijin", name="effect:geyser", aliases={"geyser", "e:geyser"}, description="Creates a geyser at the target location")
public class GeyserEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="height", aliases={"h"}, description="The height of the geyser effect", defValue="3")
    private int height;
    @MythicField(name="interval", aliases={"i", "speed", "s"}, description="The speed in ticks of the geyser animation", defValue="10")
    private final int tickInterval;
    @MythicField(name="type", aliases={"t"}, description="The type of liquid to use. Can be \"water\" or \"lava\"", defValue="water")
    private final Material type;

    public GeyserEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.height = mlc.getInteger(new String[]{"height", "h"}, 3);
        this.tickInterval = mlc.getInteger(new String[]{"interval", "i", "speed", "s"}, 10);
        String strType = mlc.getString(new String[]{"type", "t"}, "water", new String[0]);
        this.type = strType.equalsIgnoreCase("lava") ? VolatileMaterial.LAVA : (strType.equalsIgnoreCase("water") ? VolatileMaterial.WATER : VolatileMaterial.WATER);
        if (this.height <= 0) {
            this.height = 1;
        }
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data.getCaster(), target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data.getCaster(), target.getLocation());
        return SkillResult.SUCCESS;
    }

    protected void playEffect(SkillCaster am, AbstractLocation target) {
        List<AbstractPlayer> players = target.getWorld().getPlayersNearLocation(target, 50);
        new Animator(target, players);
    }

    private class Animator
    implements Runnable {
        private Task task;
        private int tick = 0;
        private AbstractLocation start;
        private List<AbstractPlayer> nearby;

        public Animator(AbstractLocation start, List<AbstractPlayer> nearby) {
            this.start = start;
            this.nearby = nearby;
            this.task = Schedulers.sync().runRepeating(this, 0L, (long)GeyserEffect.this.tickInterval);
        }

        @Override
        public void run() {
            try {
                if (this.tick > GeyserEffect.this.height * 2) {
                    this.task.terminate();
                } else if (this.tick < GeyserEffect.this.height) {
                    Block block = BukkitAdapter.adapt(this.start.clone().add(0.0, this.tick, 0.0)).getBlock();
                    if (block.getType() == Material.AIR) {
                        for (AbstractPlayer p : this.nearby) {
                            BukkitAdapter.adapt(p).sendBlockChange(block.getLocation(), GeyserEffect.this.type, (byte)0);
                        }
                    }
                } else {
                    int n = GeyserEffect.this.height - (this.tick - GeyserEffect.this.height) - 1;
                    Block block = BukkitAdapter.adapt(this.start.clone().add(0.0, n, 0.0)).getBlock();
                    for (AbstractPlayer p : this.nearby) {
                        BukkitAdapter.adapt(p).sendBlockChange(block.getLocation(), block.getBlockData());
                    }
                }
                ++this.tick;
            }
            catch (Exception ex) {
                MythicLogger.handleMinorError(ex);
                this.task.terminate();
            }
        }
    }
}

