/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Sittable;

@MythicMechanic(author="Joshinn", name="togglesitting", aliases={"sit"}, description="Toggles the sitting state of an entity for cats/dogs.")
public class ToggleSittingMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private boolean option;

    public ToggleSittingMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.option = mlc.getBoolean(new String[]{"setSitting", "state"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        LivingEntity entity = (LivingEntity)BukkitAdapter.adapt(target);
        if (entity instanceof Sittable) {
            ((Sittable)entity).setSitting(this.option);
        }
        return SkillResult.SUCCESS;
    }
}

