/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class MobsNearOriginTargeter
extends IEntitySelector {
    double radius;
    HashSet<MythicMob> mmTypes = new HashSet();
    HashSet<BukkitEntityType> meTypes = new HashSet();

    public MobsNearOriginTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getDouble("radius", 5.0);
        this.radius = mlc.getDouble("r", this.radius);
        String types = mlc.getString("types", null);
        types = mlc.getString("type", types);
        types = mlc.getString("t", types);
        String[] ss = types.split(",");
        MobsNearOriginTargeter THIS = this;
        this.getPlugin().getSkillManager().queueSecondPass(() -> {
            for (String s2 : ss) {
                MythicMob mm4 = this.getPlugin().getMobManager().getMythicMob(s2).orElseGet(() -> null);
                if (mm4 != null) {
                    THIS.mmTypes.add(mm4);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    THIS.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorTargeterConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
        });
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        ArrayList targets = Lists.newArrayList();
        block0: for (AbstractEntity p : this.getPlugin().getEntityManager().getLivingEntities(data.getCaster().getEntity().getWorld())) {
            if (p.getUniqueId().equals(data.getCaster().getEntity().getUniqueId()) || !p.getWorld().equals(data.getCaster().getEntity().getWorld()) || !(data.getOrigin().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            ActiveMob amx = this.getPlugin().getMobManager().getMythicMobInstance(p);
            if (amx != null) {
                if (!this.mmTypes.contains(amx.getType())) continue;
                targets.add(p);
                amx = null;
                continue;
            }
            for (BukkitEntityType me : this.meTypes) {
                if (!me.compare(p.getBukkitEntity())) continue;
                targets.add(p);
                continue block0;
            }
        }
        return targets;
    }
}

