/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.utils.physics;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.utils.physics.PhysicsBlock;
import io.lumine.mythic.core.utils.physics.PhysicsCollision;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class CollisionHelper {
    @NotNull
    public static List<PhysicsCollision> getCollisions(@NotNull AbstractVector velocity, @NotNull BoundingBox boundingBox, @NotNull AbstractLocation currentPosition) {
        BoundingBox intersection;
        PhysicsBlock blockAtIntersection;
        BoundingBox shiftedBoundingBox;
        BoundingBox expandedBoundingBox;
        World world = BukkitAdapter.adapt(currentPosition).getWorld();
        ArrayList<PhysicsCollision> physicsCollisions = new ArrayList<PhysicsCollision>();
        if (velocity.getX() > 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.0, 0.0, 0.001, 0.0, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(boundingBox.getWidthX(), 0.0, 0.0);
            if (shiftedBoundingBox.overlaps(expandedBoundingBox) && (blockAtIntersection = new PhysicsBlock((intersection = shiftedBoundingBox.intersection(expandedBoundingBox)).getCenter().toLocation(world).getBlock())).collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.WEST));
            }
        } else if (velocity.getX() < 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.001, 0.0, 0.0, 0.0, 0.0, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(-boundingBox.getWidthX(), 0.0, 0.0);
            if (shiftedBoundingBox.overlaps(expandedBoundingBox) && (blockAtIntersection = new PhysicsBlock((intersection = shiftedBoundingBox.intersection(expandedBoundingBox)).getCenter().toLocation(world).getBlock())).collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.EAST));
            }
        }
        if (velocity.getZ() > 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.0, 0.0, 0.0, 0.0, 0.001);
            shiftedBoundingBox = boundingBox.clone().shift(0.0, 0.0, boundingBox.getWidthZ());
            if (shiftedBoundingBox.overlaps(expandedBoundingBox) && (blockAtIntersection = new PhysicsBlock((intersection = shiftedBoundingBox.intersection(expandedBoundingBox)).getCenter().toLocation(world).getBlock())).collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.NORTH));
            }
        } else if (velocity.getZ() < 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.0, 0.001, 0.0, 0.0, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(0.0, 0.0, -boundingBox.getWidthZ());
            if (shiftedBoundingBox.overlaps(expandedBoundingBox) && (blockAtIntersection = new PhysicsBlock((intersection = shiftedBoundingBox.intersection(expandedBoundingBox)).getCenter().toLocation(world).getBlock())).collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.SOUTH));
            }
        }
        if (velocity.getY() > 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.0, 0.0, 0.0, 0.001, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(0.0, boundingBox.getHeight(), 0.0);
            if (shiftedBoundingBox.overlaps(expandedBoundingBox) && (blockAtIntersection = new PhysicsBlock((intersection = shiftedBoundingBox.intersection(expandedBoundingBox)).getCenter().toLocation(world).getBlock())).collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.DOWN));
            }
        } else if (velocity.getY() < 0.0) {
            expandedBoundingBox = boundingBox.clone().expand(0.0, 0.001, 0.0, 0.0, 0.001, 0.0);
            shiftedBoundingBox = boundingBox.clone().shift(0.0, -boundingBox.getHeight(), 0.0);
            if (shiftedBoundingBox.overlaps(expandedBoundingBox) && (blockAtIntersection = new PhysicsBlock((intersection = shiftedBoundingBox.intersection(expandedBoundingBox)).getCenter().toLocation(world).getBlock())).collidesWith(intersection)) {
                physicsCollisions.add(new PhysicsCollision(blockAtIntersection.getBlock(), BlockFace.UP));
            }
        }
        return physicsCollisions;
    }
}

