/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_19_R2.virtual;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntity;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Set;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public abstract class VirtualEntity<T extends PacketEntity<?>>
extends PacketEntityRenderer<T> {
    public VirtualEntity(T wrapper) {
        super(wrapper);
    }

    @Override
    public Collection<Object> getSpawnPackets(AbstractPlayer target) {
        Player player = BukkitAdapter.adapt(target);
        PacketPlayOutSpawnEntity packetSpawn = this.createSpawnPacket();
        PacketPlayOutEntityMetadata packetData = this.createDataPacket(true);
        return Lists.newArrayList((Object[])new Object[]{packetSpawn, packetData});
    }

    @Override
    public void sendPacket(Object ... packets) {
        Schedulers.ensureAsync(() -> {
            Set set = this.trackedPlayers.keySet();
            for (Object object : packets) {
                if (object == null || !(object instanceof Packet)) continue;
                Packet packet = (Packet)object;
                for (AbstractPlayer player : set) {
                    ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a(packet);
                }
            }
        });
    }

    @Override
    public void sendPacket(AbstractPlayer player, Object ... packets) {
        Schedulers.ensureAsync(() -> {
            Set set = this.trackedPlayers.keySet();
            for (Object object : packets) {
                if (object == null || !(object instanceof Packet)) continue;
                Packet packet = (Packet)object;
                ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a(packet);
            }
        });
    }

    @Override
    public void sendPacket(AbstractPlayer player, Collection<Object> packets) {
        Schedulers.ensureAsync(() -> {
            Set set = this.trackedPlayers.keySet();
            for (Object object : packets) {
                if (object == null || !(object instanceof Packet)) continue;
                Packet packet = (Packet)object;
                ((CraftPlayer)player.getBukkitEntity()).getHandle().b.a(packet);
            }
        });
    }

    @Override
    public void mountEntity(AbstractEntity entity) {
        int id = entity.getBukkitEntity().getEntityId();
        PacketPlayOutMount packet = this.createMountPacket(id);
        this.mount = id;
        this.sendPacket(packet);
    }

    @Override
    public void addPassenger(PacketEntityRenderer entity) {
        PacketPlayOutMount packet = this.createPassengerPacket(entity.getEntityId());
        entity.setMount(this.entityId);
        this.sendPacket(packet);
    }

    protected abstract PacketPlayOutSpawnEntity createSpawnPacket();

    protected PacketPlayOutSpawnEntity createSpawnPacket(EntityTypes entityType) {
        AbstractLocation location = ((PacketEntity)this.getWrapper()).getLocation().get();
        return new PacketPlayOutSpawnEntity(this.getEntityId(), this.getUniqueId(), location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, entityType, 0, Vec3D.b, 0.0);
    }

    protected abstract PacketPlayOutEntityMetadata createDataPacket(boolean var1);

    protected PacketPlayOutEntityDestroy createRemovePacket() {
        return new PacketPlayOutEntityDestroy(new int[]{this.entityId});
    }

    protected PacketPlayOutEntityVelocity createVelocityPacket(double x, double y, double z) {
        return new PacketPlayOutEntityVelocity(this.entityId, new Vec3D(x, y, z));
    }

    protected PacketPlayOutEntityTeleport createTeleportPacket(double x, double y, double z, float yaw, float pitch) {
        PacketDataSerializer pos = new PacketDataSerializer(Unpooled.buffer());
        pos.d(this.entityId);
        pos.writeDouble(x);
        pos.writeDouble(y);
        pos.writeDouble(z);
        pos.writeByte((int)((byte)(yaw / 360.0f * 255.0f)));
        pos.writeByte(0);
        pos.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(pos);
    }

    protected PacketPlayOutMount createMountPacket(int vehicleId) {
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.d(vehicleId);
        mount.d(1);
        mount.d(this.entityId);
        return new PacketPlayOutMount(mount);
    }

    protected PacketPlayOutMount createPassengerPacket(int passengerId) {
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.d(this.entityId);
        mount.d(1);
        mount.d(passengerId);
        return new PacketPlayOutMount(mount);
    }

    protected PacketPlayOutMount createPassengerPacket(Set<Entity> passengers) {
        PacketDataSerializer mount = new PacketDataSerializer(Unpooled.buffer());
        mount.d(this.entityId);
        mount.d(passengers.size());
        for (Entity ent : passengers) {
            mount.d(ent.ah());
        }
        return new PacketPlayOutMount(mount);
    }

    public static <T> void writeData(PacketDataSerializer byteBuf, int id, DataWatcherSerializer<T> serializer, T val) {
        int serializedId = DataWatcherRegistry.b(serializer);
        byteBuf.writeByte(id);
        byteBuf.d(serializedId);
        serializer.a(byteBuf, val);
    }
}

