/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.javassist.convert;

import pers.neige.neigeitems.javassist.CtClass;
import pers.neige.neigeitems.javassist.CtMethod;
import pers.neige.neigeitems.javassist.NotFoundException;
import pers.neige.neigeitems.javassist.bytecode.BadBytecode;
import pers.neige.neigeitems.javassist.bytecode.Bytecode;
import pers.neige.neigeitems.javassist.bytecode.CodeAttribute;
import pers.neige.neigeitems.javassist.bytecode.CodeIterator;
import pers.neige.neigeitems.javassist.bytecode.ConstPool;
import pers.neige.neigeitems.javassist.bytecode.Descriptor;
import pers.neige.neigeitems.javassist.convert.TransformCall;
import pers.neige.neigeitems.javassist.convert.Transformer;

public class TransformBefore
extends TransformCall {
    protected CtClass[] parameterTypes;
    protected int locals;
    protected int maxLocals;
    protected byte[] saveCode;
    protected byte[] loadCode;

    public TransformBefore(Transformer next, CtMethod origMethod, CtMethod beforeMethod) throws NotFoundException {
        super(next, origMethod, beforeMethod);
        this.methodDescriptor = origMethod.getMethodInfo2().getDescriptor();
        this.parameterTypes = origMethod.getParameterTypes();
        this.locals = 0;
        this.maxLocals = 0;
        this.loadCode = null;
        this.saveCode = null;
    }

    @Override
    public void initialize(ConstPool cp, CodeAttribute attr) {
        super.initialize(cp, attr);
        this.locals = 0;
        this.maxLocals = attr.getMaxLocals();
        this.loadCode = null;
        this.saveCode = null;
    }

    @Override
    protected int match(int c, int pos, CodeIterator iterator, int typedesc, ConstPool cp) throws BadBytecode {
        if (this.newIndex == 0) {
            String desc = Descriptor.ofParameters(this.parameterTypes) + 'V';
            desc = Descriptor.insertParameter(this.classname, desc);
            int nt = cp.addNameAndTypeInfo(this.newMethodname, desc);
            int ci = cp.addClassInfo(this.newClassname);
            this.newIndex = cp.addMethodrefInfo(ci, nt);
            this.constPool = cp;
        }
        if (this.saveCode == null) {
            this.makeCode(this.parameterTypes, cp);
        }
        return this.match2(pos, iterator);
    }

    protected int match2(int pos, CodeIterator iterator) throws BadBytecode {
        iterator.move(pos);
        iterator.insert(this.saveCode);
        iterator.insert(this.loadCode);
        int p = iterator.insertGap(3);
        iterator.writeByte(184, p);
        iterator.write16bit(this.newIndex, p + 1);
        iterator.insert(this.loadCode);
        return iterator.next();
    }

    @Override
    public int extraLocals() {
        return this.locals;
    }

    protected void makeCode(CtClass[] paramTypes, ConstPool cp) {
        Bytecode save2 = new Bytecode(cp, 0, 0);
        Bytecode load2 = new Bytecode(cp, 0, 0);
        int var = this.maxLocals;
        int len = paramTypes == null ? 0 : paramTypes.length;
        load2.addAload(var);
        this.makeCode2(save2, load2, 0, len, paramTypes, var + 1);
        save2.addAstore(var);
        this.saveCode = save2.get();
        this.loadCode = load2.get();
    }

    private void makeCode2(Bytecode save2, Bytecode load2, int i, int n, CtClass[] paramTypes, int var) {
        if (i < n) {
            int size = load2.addLoad(var, paramTypes[i]);
            this.makeCode2(save2, load2, i + 1, n, paramTypes, var + size);
            save2.addStore(var, paramTypes[i]);
        } else {
            this.locals = var - this.maxLocals;
        }
    }
}

