/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.section.impl;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin1720.collections.ArraysKt;
import kotlin1720.collections.CollectionsKt;
import kotlin1720.jvm.internal.Intrinsics;
import kotlin1720.ranges.RangesKt;
import kotlin1720.text.StringsKt;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.neige.neigeitems.section.SectionParser;
import pers.neige.neigeitems.utils.StringUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jv\u0010\u0007\u001a\u0004\u0018\u00010\u00042&\u0010\b\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tj\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0002JR\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172&\u0010\b\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tj\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016JN\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u000e2&\u0010\b\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tj\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lpers/neige/neigeitems/section/impl/GradientParser;", "Lpers/neige/neigeitems/section/SectionParser;", "()V", "id", "", "getId", "()Ljava/lang/String;", "handler", "cache", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "player", "Lorg/bukkit/OfflinePlayer;", "sections", "Lorg/bukkit/configuration/ConfigurationSection;", "parse", "", "colorStartString", "colorEndString", "stepString", "text", "onRequest", "args", "", "data", "NeigeItems"})
public final class GradientParser
extends SectionParser {
    @NotNull
    public static final GradientParser INSTANCE = new GradientParser();
    @NotNull
    private static final String id = "gradient";

    private GradientParser() {
    }

    @Override
    @NotNull
    public String getId() {
        return id;
    }

    @Override
    @Nullable
    public String onRequest(@NotNull ConfigurationSection data, @Nullable HashMap<String, String> cache, @Nullable OfflinePlayer player, @Nullable ConfigurationSection sections) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.handler(cache, player, sections, true, data.getString("colorStart"), data.getString("colorEnd"), data.getString("step"), data.getString("text"));
    }

    @Override
    @NotNull
    public String onRequest(@NotNull List<String> args, @Nullable HashMap<String, String> cache, @Nullable OfflinePlayer player, @Nullable ConfigurationSection sections) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String string = this.handler(cache, player, sections, false, (String)CollectionsKt.getOrNull(args, (int)0), (String)CollectionsKt.getOrNull(args, (int)1), (String)CollectionsKt.getOrNull(args, (int)2), StringUtils.joinToString(args, "_", 3));
        if (string == null) {
            string = '<' + this.getId() + "::" + StringUtils.joinToString$default(args, "_", 0, 2, null) + '>';
        }
        return string;
    }

    private final String handler(HashMap<String, String> cache, OfflinePlayer player, ConfigurationSection sections, boolean parse, String colorStartString, String colorEndString, String stepString, String text) {
        if (colorStartString != null && colorEndString != null && text != null) {
            Integer n = StringsKt.toIntOrNull((String)colorStartString, (int)16);
            Color colorStart = new Color(RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)(n != null ? n : 0), (int)0), (int)0xFFFFFF));
            Integer n2 = StringsKt.toIntOrNull((String)colorEndString, (int)16);
            Color colorEnd = new Color(RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)(n2 != null ? n2 : 0), (int)0), (int)0xFFFFFF));
            Object object = stepString;
            int step = RangesKt.coerceAtLeast((int)(object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1), (int)1);
            if (text.length() <= step) {
                return ChatColor.of((Color)colorStart).toString() + text;
            }
            char[] cArray = text.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            char[] chars = cArray;
            StringBuilder result2 = new StringBuilder();
            int redCurrent = colorStart.getRed();
            int greenCurrent = colorStart.getGreen();
            int blueCurrent = colorStart.getBlue();
            if (step == 1) {
                int redStep = (colorEnd.getRed() - colorStart.getRed()) / ArraysKt.getLastIndex((char[])chars);
                int greenStep = (colorEnd.getGreen() - colorStart.getGreen()) / ArraysKt.getLastIndex((char[])chars);
                int blueStep = (colorEnd.getBlue() - colorStart.getBlue()) / ArraysKt.getLastIndex((char[])chars);
                for (char c : chars) {
                    result2.append(ChatColor.of((Color)new Color(redCurrent, greenCurrent, blueCurrent)).toString());
                    result2.append(c);
                    redCurrent += redStep;
                    greenCurrent += greenStep;
                    blueCurrent += blueStep;
                }
            } else {
                int redStep = (colorEnd.getRed() - colorStart.getRed()) * step / ArraysKt.getLastIndex((char[])chars);
                int greenStep = (colorEnd.getGreen() - colorStart.getGreen()) * step / ArraysKt.getLastIndex((char[])chars);
                int blueStep = (colorEnd.getBlue() - colorStart.getBlue()) * step / ArraysKt.getLastIndex((char[])chars);
                int current = 1;
                for (char c : chars) {
                    if (current == 1) {
                        result2.append(ChatColor.of((Color)new Color(redCurrent, greenCurrent, blueCurrent)).toString());
                        redCurrent += redStep;
                        greenCurrent += greenStep;
                        blueCurrent += blueStep;
                    }
                    result2.append(c);
                    if (current == step) {
                        current = 1;
                        continue;
                    }
                    ++current;
                }
            }
            return result2.toString();
        }
        return null;
    }
}

