/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.taboolib.module.metrics;

import java.io.File;
import java.util.Map;
import java.util.UUID;
import kotlin1720.Unit;
import kotlin1720.jvm.functions.Function1;
import pers.neige.neigeitems.taboolib.common.TabooLibCommon;
import pers.neige.neigeitems.taboolib.common.io.File1Kt;
import pers.neige.neigeitems.taboolib.common.platform.Platform;
import pers.neige.neigeitems.taboolib.common.platform.function.AdapterKt;
import pers.neige.neigeitems.taboolib.common.platform.function.ExecutorKt;
import pers.neige.neigeitems.taboolib.common.platform.function.IOKt;
import pers.neige.neigeitems.taboolib.common.platform.service.PlatformExecutor;
import pers.neige.neigeitems.taboolib.module.configuration.SecuredFile;
import pers.neige.neigeitems.taboolib.module.metrics.CustomChart;
import pers.neige.neigeitems.taboolib.module.metrics.JsonBuilder;
import pers.neige.neigeitems.taboolib.module.metrics.MetricsBase;

public class Metrics {
    private MetricsBase metricsBase;

    public Metrics(int serviceId, String pluginVersion, Platform runningPlatform) {
        String platform;
        if (TabooLibCommon.getRunningPlatform() != runningPlatform) {
            return;
        }
        File bStatsFolder = new File(IOKt.getDataFolder().getParentFile(), "bStats");
        File configFile = File1Kt.newFile(bStatsFolder, "config.yml", true, false);
        SecuredFile config = SecuredFile.Companion.loadConfiguration(configFile);
        if (!config.contains("serverUUID")) {
            config.set("enabled", true);
            config.set("serverUUID", UUID.randomUUID().toString());
            config.set("logFailedRequests", false);
            config.set("logSentData", false);
            config.set("logResponseStatusText", false);
            config.saveToFile(configFile);
        }
        boolean enabled = config.getBoolean("enabled", true);
        String serverUUID = config.getString("serverUUID");
        boolean logErrors = config.getBoolean("logFailedRequests", false);
        boolean logSentData = config.getBoolean("logSentData", false);
        boolean logResponseStatusText = config.getBoolean("logResponseStatusText", false);
        switch (runningPlatform) {
            case UNKNOWN: 
            case BUKKIT: 
            case NUKKIT: {
                platform = "bukkit";
                break;
            }
            case BUNGEE: {
                platform = "bungeecord";
                break;
            }
            case VELOCITY: {
                platform = "velocity";
                break;
            }
            case SPONGE_API_7: 
            case SPONGE_API_8: {
                platform = "sponge";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported");
            }
        }
        this.metricsBase = new MetricsBase(platform, serverUUID, serviceId, enabled, json -> this.appendPlatformData((JsonBuilder)json, runningPlatform), json -> this.appendServiceData((JsonBuilder)json, pluginVersion), task -> ExecutorKt.submit(false, false, 0L, 0L, "", (Function1<? super PlatformExecutor.PlatformTask, Unit>)((Function1)r -> {
            task.run();
            return Unit.INSTANCE;
        })), () -> true, (message, error) -> IOKt.warning(message), xva$0 -> IOKt.info(xva$0), logErrors, logSentData, logResponseStatusText);
    }

    public void addCustomChart(CustomChart chart) {
        this.metricsBase.addCustomChart(chart);
    }

    private void appendPlatformData(JsonBuilder builder, Platform platform) {
        builder.appendField("playerAmount", AdapterKt.onlinePlayers().size());
        builder.appendField("javaVersion", System.getProperty("java.version"));
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
        Map<String, Object> platformData = IOKt.getPlatformData();
        for (Map.Entry<String, Object> entry : platformData.entrySet()) {
            if (entry.getValue() instanceof Integer) {
                if (platform == Platform.NUKKIT) {
                    builder.appendField(entry.getKey().replace("nukkit", "bukkit"), (Integer)entry.getValue());
                    continue;
                }
                builder.appendField(entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            if (platform == Platform.NUKKIT) {
                builder.appendField(entry.getKey().replace("nukkit", "bukkit"), entry.getValue().toString());
                continue;
            }
            builder.appendField(entry.getKey(), entry.getValue().toString());
        }
    }

    private void appendServiceData(JsonBuilder builder, String version) {
        builder.appendField("pluginVersion", version);
    }
}

