/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.bungee.impl;

import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.PlHideProxyPlayer;
import eu.nononitas.plhidepro.api.PlHideAPIProvider;
import eu.nononitas.plhidepro.api.event.EventManager;
import eu.nononitas.plhidepro.api.event.SetGroupEvent;
import eu.nononitas.plhidepro.api.group.GroupMode;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.bungee.PlHideProBungee;
import eu.nononitas.plhidepro.group.Group;
import eu.nononitas.plhidepro.group.ProxyGroup;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class PlHideBungeePlayer
implements PlHideProxyPlayer {
    private final ProxiedPlayer player;
    private Group group;
    private final PlHidePro plHide;

    public PlHideBungeePlayer(ProxiedPlayer proxiedPlayer, PlHidePro plHidePro) {
        this.player = proxiedPlayer;
        this.plHide = plHidePro;
        this.updateGroup();
    }

    @Override
    public <P> P getHandle() {
        return (P)this.player;
    }

    @Override
    public IGroup getGroup() {
        return this.group;
    }

    @Override
    public void updateGroup() {
        EventManager eventManager = PlHideAPIProvider.getApi().getEventManager();
        SetGroupEvent setGroupEvent = new SetGroupEvent(this, ProxyGroup.getGroup(this, this.plHide));
        eventManager.executeEvent(setGroupEvent);
        this.group = (Group)setGroupEvent.getGroup();
        if (!this.isLegacy()) {
            PlHideProBungee.getInstance().getPluginMessageHandler().requestTabcompletions(this.player);
        }
    }

    @Override
    public GroupMode getGroupModeCommands() {
        return this.player.hasPermission("plhide.blacklist.commands") ? GroupMode.BLACKLIST : GroupMode.WHITELIST;
    }

    @Override
    public GroupMode getGroupModeTabcomplete() {
        return this.player.hasPermission("plhide.blacklist.tabcomplete") ? GroupMode.BLACKLIST : GroupMode.WHITELIST;
    }

    @Override
    public boolean unblockPluginNamedCommandsExecution() {
        return this.player.hasPermission("plhide.unblock-plugin-named-commands.execution");
    }

    @Override
    public boolean unblockPluginNamedCommandsTabcomplete() {
        return this.player.hasPermission("plhide.unblock-plugin-named-commands.tabcomplete");
    }

    @Override
    public String getServerName() {
        return this.player.getServer().getInfo().getName();
    }

    @Override
    public boolean hasPermission(String string) {
        return this.player.hasPermission(string);
    }

    @Override
    public boolean isLegacy() {
        return this.player.getPendingConnection().getVersion() < 393;
    }
}

