/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.group;

import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.api.group.Node;
import eu.nononitas.plhidepro.miscellaneous.CommandsListManager;
import eu.nononitas.plhidepro.util.PluginCommandsInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class Group
implements IGroup {
    protected List<String> groupNameList;
    protected List<String> commandsList;
    protected List<String> tabcompleteList;
    protected List<String> inheritedGroups;
    protected Node<String> rootCommandsNode;
    protected Node<String> rootTabNode;
    protected boolean isLegacy;
    protected final PlHidePro plHide;

    public Group(PlHidePro plHidePro) {
        this.plHide = plHidePro;
    }

    @Override
    public final List<String> getGroupNames() {
        return Collections.unmodifiableList(this.groupNameList);
    }

    protected abstract List<String> getConfigList(Type var1);

    protected void replacePluginAndList(List<String> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Object object;
            String string = list.get(i);
            if (string.startsWith("plugin:")) {
                list.remove(i);
                object = PluginCommandsInfo.getCommands(string.replace("plugin:", ""));
                if (object.isEmpty()) {
                    this.plHide.getLogger().warn("Can't find commands for plugin " + string.replace("plugin:", ""));
                    continue;
                }
                list.addAll((Collection<String>)object);
                continue;
            }
            if (!string.startsWith("list:")) continue;
            list.remove(i);
            object = this.plHide.getListManager();
            String string2 = string.replaceFirst("list:", "");
            if (!((CommandsListManager)object).hasList(string2)) {
                this.plHide.getLogger().warn("Couldn't find the list \"" + string2);
                continue;
            }
            list.addAll(((CommandsListManager)object).getList(string2));
        }
    }

    @Override
    public List<String> getTabcompleteList() {
        if (this.tabcompleteList == null) {
            this.tabcompleteList = this.getConfigList(Type.TABCOMPLETE);
        }
        return this.tabcompleteList;
    }

    @Override
    public List<String> getCommandList() {
        if (this.commandsList == null) {
            this.commandsList = this.getConfigList(Type.COMMANDS);
        }
        return this.commandsList;
    }

    @Override
    public List<String> getInheritedGroups() {
        if (this.inheritedGroups == null) {
            this.inheritedGroups = this.getInheritedGroups(new ArrayList<String>());
            this.inheritedGroups.removeIf(string -> this.groupNameList.contains(string));
        }
        return this.inheritedGroups;
    }

    protected abstract List<String> getInheritedGroups(List<String> var1);

    @Override
    public Node<String> getRootCommandNode() {
        if (this.rootCommandsNode == null) {
            this.rootCommandsNode = this.getRootNode(this.getCommandList());
        }
        return this.rootCommandsNode;
    }

    @Override
    public Node<String> getRootTabNode() {
        if (this.rootTabNode == null) {
            this.rootTabNode = this.getRootNode(this.getTabcompleteList());
        }
        return this.rootTabNode;
    }

    private Node<String> getRootNode(List<String> list) {
        Node<String> node = new Node<String>();
        for (String string : list) {
            Node<String> node2 = node;
            for (String string2 : string.split(" ")) {
                if (string2.contains("%space%")) {
                    string2 = string2.replace("%space%", " ");
                }
                node2 = node2.addChildren(string2.toLowerCase(Locale.ROOT));
            }
        }
        return node;
    }

    public static enum Type {
        COMMANDS,
        TABCOMPLETE;

    }
}

