/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.libs.net.byteflux.libby;

import eu.nononitas.plhidepro.libs.net.byteflux.libby.relocation.Relocation;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.UUID;

public class Library {
    private final Collection<String> urls;
    private final Collection<String> repositories;
    private final String id;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final byte[] checksum;
    private final Collection<Relocation> relocations;
    private final String path;
    private final String partialPath;
    private final String relocatedPath;
    private final boolean isolatedLoad;

    private Library(Collection<String> collection, String string, String string2, String string3, String string4, String string5, byte[] byArray, Collection<Relocation> collection2, boolean bl) {
        this(collection, null, string, string2, string3, string4, string5, byArray, collection2, bl);
    }

    private Library(Collection<String> collection, Collection<String> collection2, String string, String string2, String string3, String string4, String string5, byte[] byArray, Collection<Relocation> collection3, boolean bl) {
        this.urls = collection != null ? Collections.unmodifiableList(new LinkedList<String>(collection)) : Collections.emptyList();
        this.id = string != null ? string : UUID.randomUUID().toString();
        this.groupId = Objects.requireNonNull(string2, "groupId").replace("{}", ".");
        this.artifactId = Objects.requireNonNull(string3, "artifactId");
        this.version = Objects.requireNonNull(string4, "version");
        this.classifier = string5;
        this.checksum = byArray;
        this.relocations = collection3 != null ? Collections.unmodifiableList(new LinkedList<Relocation>(collection3)) : Collections.emptyList();
        this.partialPath = this.groupId.replace('.', '/') + '/' + string3 + '/' + string4 + '/';
        String string6 = this.partialPath + string3 + '-' + string4;
        if (this.hasClassifier()) {
            string6 = string6 + '-' + string5;
        }
        this.path = string6 + ".jar";
        this.repositories = collection2 != null ? Collections.unmodifiableList(new LinkedList<String>(collection2)) : Collections.emptyList();
        this.relocatedPath = this.hasRelocations() ? string6 + "-relocated.jar" : null;
        this.isolatedLoad = bl;
    }

    public Collection<String> getUrls() {
        return this.urls;
    }

    public Collection<String> getRepositories() {
        return this.repositories;
    }

    public String getId() {
        return this.id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean hasClassifier() {
        return this.classifier != null;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public boolean hasChecksum() {
        return this.checksum != null;
    }

    public Collection<Relocation> getRelocations() {
        return this.relocations;
    }

    public boolean hasRelocations() {
        return !this.relocations.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public String getPartialPath() {
        return this.partialPath;
    }

    public String getRelocatedPath() {
        return this.relocatedPath;
    }

    public boolean isIsolatedLoad() {
        return this.isolatedLoad;
    }

    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public String toString() {
        String string = this.groupId + ':' + this.artifactId + ':' + this.version;
        if (this.hasClassifier()) {
            string = string + ':' + this.classifier;
        }
        return string;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Collection<String> urls = new LinkedList<String>();
        private final Collection<String> repositories = new LinkedList<String>();
        private String id;
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;
        private byte[] checksum;
        private boolean isolatedLoad;
        private final Collection<Relocation> relocations = new LinkedList<Relocation>();

        public Builder url(String string) {
            this.urls.add(Objects.requireNonNull(string, "url"));
            return this;
        }

        public Builder repository(String string) {
            this.repositories.add(Objects.requireNonNull(string, "repository").endsWith("/") ? string : string + '/');
            return this;
        }

        public Builder id(String string) {
            this.id = string != null ? string : UUID.randomUUID().toString();
            return this;
        }

        public Builder groupId(String string) {
            this.groupId = Objects.requireNonNull(string, "groupId");
            return this;
        }

        public Builder artifactId(String string) {
            this.artifactId = Objects.requireNonNull(string, "artifactId");
            return this;
        }

        public Builder version(String string) {
            this.version = Objects.requireNonNull(string, "version");
            return this;
        }

        public Builder classifier(String string) {
            this.classifier = Objects.requireNonNull(string, "classifier");
            return this;
        }

        public Builder checksum(byte[] byArray) {
            this.checksum = Objects.requireNonNull(byArray, "checksum");
            return this;
        }

        public Builder checksum(String string) {
            return this.checksum(Base64.getDecoder().decode(Objects.requireNonNull(string, "checksum")));
        }

        public Builder isolatedLoad(boolean bl) {
            this.isolatedLoad = bl;
            return this;
        }

        public Builder relocate(Relocation relocation) {
            this.relocations.add(Objects.requireNonNull(relocation, "relocation"));
            return this;
        }

        public Builder relocate(String string, String string2) {
            return this.relocate(new Relocation(string, string2));
        }

        public Library build() {
            return new Library(this.urls, this.repositories, this.id, this.groupId, this.artifactId, this.version, this.classifier, this.checksum, this.relocations, this.isolatedLoad);
        }
    }
}

