/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.miscellaneous;

import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.miscellaneous.IConfig;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CommandsListManager {
    private final HashMap<String, List<String>> listHashMap = new HashMap();
    private final PlHidePro plHidePro;

    public CommandsListManager(PlHidePro plHidePro) {
        this.plHidePro = plHidePro;
    }

    public void loadLists() {
        File file = new File(this.plHidePro.getDataFolder(), "lists");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (!file2.getName().endsWith(".yml")) continue;
                IConfig iConfig = this.plHidePro.getConfig(file2);
                for (String string : iConfig.getAllKeys()) {
                    try {
                        this.registerList(string, iConfig.getStringList(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.plHidePro.getLogger().warn("The list " + string + " may only defined once");
                    }
                }
            }
        } else {
            this.plHidePro.getLogger().error("Please delete the file " + file);
        }
    }

    public void registerList(@NotNull String string, @NotNull List<String> list) {
        if (this.listHashMap.containsKey(string)) {
            throw new IllegalArgumentException("The list " + string + " is already registered");
        }
        this.listHashMap.put(string, Collections.unmodifiableList(list));
    }

    public boolean hasList(String string) {
        return this.listHashMap.containsKey(string);
    }

    public List<String> getList(String string) {
        return this.listHashMap.getOrDefault(string, Collections.emptyList());
    }

    public void clearLists() {
        this.listHashMap.clear();
    }
}

