/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.miscellaneous;

import eu.nononitas.plhidepro.PlHideProvider;
import java.util.UUID;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.model.PermissionHolder;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.PermissionNode;
import net.luckperms.api.node.types.RegexPermissionNode;

public class LuckPermsListener {
    public static void init(Object object) {
        EventBus eventBus = LuckPermsProvider.get().getEventBus();
        eventBus.subscribe(object, NodeRemoveEvent.class, nodeRemoveEvent -> {
            if (!nodeRemoveEvent.isUser()) {
                return;
            }
            LuckPermsListener.handleNodeChange(nodeRemoveEvent.getNode(), nodeRemoveEvent.getTarget());
        });
        eventBus.subscribe(object, NodeAddEvent.class, nodeAddEvent -> {
            if (!nodeAddEvent.isUser()) {
                return;
            }
            LuckPermsListener.handleNodeChange(nodeAddEvent.getNode(), nodeAddEvent.getTarget());
        });
    }

    private static void handleNodeChange(Node node, PermissionHolder permissionHolder) {
        if (node instanceof PermissionNode || node instanceof RegexPermissionNode) {
            if (node.getKey().startsWith("plhide.group.")) {
                LuckPermsListener.update(permissionHolder);
            }
        } else if (node instanceof InheritanceNode) {
            LuckPermsListener.update(permissionHolder);
        }
    }

    private static void update(PermissionHolder permissionHolder) {
        UUID uUID = UUID.fromString(permissionHolder.getIdentifier().getName());
        Object PlHPlayer = PlHideProvider.getPlHidePro().getPlayerManager().getPlHidePlayer(uUID);
        if (PlHPlayer == null) {
            return;
        }
        PlHideProvider.getPlHidePro().getLogger().debug("Auto updating group of " + permissionHolder.getFriendlyName());
        PlHPlayer.updateGroup();
    }
}

