/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.miscellaneous;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.miscellaneous.ILogger;
import eu.nononitas.plhidepro.util.PluginCommandsInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public abstract class PluginMessageHandler<P> {
    private final Cache<String, PluginCommandsParts> cache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).expireAfterWrite(30L, TimeUnit.SECONDS).build();
    protected final PlHidePro plHide;

    public PluginMessageHandler(PlHidePro plHidePro) {
        this.plHide = plHidePro;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessageReceive(byte[] byArray) {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));){
            String string;
            switch (string = objectInputStream.readUTF()) {
                case "plugin_commands": {
                    this.handlePluginCommands(objectInputStream);
                    return;
                }
                case "group_update": {
                    this.handleGroupUpdate(objectInputStream);
                    return;
                }
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void handlePluginCommands(ObjectInputStream objectInputStream) {
        Object object;
        int n;
        String string = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        ILogger iLogger = this.plHide.getLogger();
        if (string2.startsWith("l:")) {
            iLogger.debug("Received init plugin-data from " + string);
            n = Integer.parseInt(string2.replaceFirst("l:", ""));
            this.cache.put((Object)string, (Object)new PluginCommandsParts(n));
            string2 = objectInputStream.readUTF();
        }
        n = Integer.parseInt(string2.replace("i:", ""));
        PluginCommandsParts pluginCommandsParts = (PluginCommandsParts)this.cache.getIfPresent((Object)string);
        if (pluginCommandsParts == null) {
            iLogger.debug("plugin-data from " + string + " is expired");
            return;
        }
        try {
            object = objectInputStream.readAllBytes();
            iLogger.debug("Setting partial plugin-data from " + string);
            pluginCommandsParts.setPart(n, (byte[])object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (pluginCommandsParts.size - 1 == n) {
            object = pluginCommandsParts.build();
            iLogger.debug("Finalizing plugin-data from " + string);
            PluginCommandsInfo.addCommands((HashMap<String, HashSet<String>>)object);
            this.plHide.getDatabase().submitPluginData((HashMap<String, HashSet<String>>)object);
        }
    }

    private void handleGroupUpdate(ObjectInputStream objectInputStream) {
        UUID uUID = UUID.fromString(objectInputStream.readUTF());
        Object PlHPlayer = this.plHide.getPlayerManager().getPlHidePlayer(uUID);
        this.plHide.getLogger().debug("Updating group for " + uUID);
        if (PlHPlayer != null) {
            PlHPlayer.updateGroup();
        }
    }

    public abstract void requestTabcompletions(P var1);

    private class PluginCommandsParts {
        private final byte[][] bytes;
        private final int size;

        public PluginCommandsParts(int n) {
            this.size = n;
            this.bytes = new byte[n][];
        }

        public void setPart(int n, byte[] byArray) {
            this.bytes[n] = byArray;
        }

        public int getSize() {
            return this.size;
        }

        public HashMap<String, HashSet<String>> build() {
            HashMap hashMap;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mergeByteArrays());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                hashMap = (HashMap)objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        objectInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    return new HashMap<String, HashSet<String>>();
                }
            }
            objectInputStream.close();
            return hashMap;
        }

        private byte[] mergeByteArrays() {
            int n = 0;
            for (byte[] byArray : this.bytes) {
                n += byArray.length;
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            for (byte[] byArray2 : this.bytes) {
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
            }
            return byArray;
        }
    }
}

