/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.modifier;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import eu.nononitas.plhidepro.api.group.GroupMode;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.api.group.Node;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import java.util.Iterator;
import java.util.Locale;

public class SuggestionEditor {
    public static void editSuggestion(RootCommandNode<?> rootCommandNode, PlHidePlayer plHidePlayer) {
        IGroup iGroup = plHidePlayer.getGroup();
        if (plHidePlayer.getGroupModeTabcomplete() == GroupMode.BLACKLIST) {
            if (!plHidePlayer.unblockPluginNamedCommandsTabcomplete()) {
                rootCommandNode.getChildren().removeIf(commandNode -> commandNode.getName().contains(":"));
            }
            SuggestionEditor.applyBlacklist(rootCommandNode, iGroup.getRootTabNode());
        } else {
            SuggestionEditor.applyWhitelist(rootCommandNode, iGroup.getRootTabNode());
        }
    }

    private static void applyBlacklist(CommandNode<?> commandNode2, Node<String> node) {
        if (commandNode2.getRedirect() != null) {
            commandNode2 = commandNode2.getRedirect();
        }
        commandNode2.getChildren().removeIf(commandNode -> {
            String string = commandNode.getName().toLowerCase(Locale.ROOT);
            if (node.containsChildren(string)) {
                Node<String> node2 = node.getChild(string);
                if (node2.hasChildren()) {
                    SuggestionEditor.applyBlacklist(commandNode, node2);
                } else {
                    return true;
                }
            }
            return false;
        });
    }

    private static void applyWhitelist(CommandNode<?> commandNode, Node<String> node) {
        if (commandNode.getRedirect() != null) {
            commandNode = commandNode.getRedirect();
        }
        Iterator iterator = commandNode.getChildren().iterator();
        while (iterator.hasNext()) {
            CommandNode commandNode2 = (CommandNode)iterator.next();
            String string = commandNode2.getName().toLowerCase(Locale.ROOT);
            if (node.isRoot() && !node.containsChildren(string) && !string.equals("args")) {
                iterator.remove();
                continue;
            }
            if (!node.hasChildren()) continue;
            if (node.containsChildren(string)) {
                SuggestionEditor.applyWhitelist(commandNode2, node.getChild(string));
                continue;
            }
            if (node.containsChildren("~")) {
                commandNode.getChildren().clear();
                break;
            }
            if (node.containsChildren("*")) {
                SuggestionEditor.applyWhitelist(commandNode2, node.getChild("*"));
                continue;
            }
            if (string.equals("args")) continue;
            iterator.remove();
        }
    }
}

