/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.modifier;

import eu.nononitas.plhidepro.api.group.GroupMode;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.api.group.Node;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class TabCompleteEditor {
    private final List<String> suggestionList;
    private final PlHidePlayer plHidePlayer;
    private final IGroup group;
    private List<String> splittedInput;
    private String input;

    public TabCompleteEditor(PlHidePlayer plHidePlayer, String string, List<String> list) {
        this.plHidePlayer = plHidePlayer;
        this.group = plHidePlayer.getGroup();
        this.input = string.toLowerCase(Locale.ROOT);
        this.suggestionList = list;
    }

    public TabCompleteEditor setLegacyCompletion() {
        if (!this.input.endsWith(" ")) {
            String string;
            int n = this.input.lastIndexOf(" ");
            if (n == -1) {
                string = this.input = "";
            } else {
                string = this.input.substring(n + 1);
                this.input = this.input.substring(0, n);
            }
            this.suggestionList.removeIf(string2 -> !string2.toLowerCase(Locale.ROOT).startsWith(string));
        }
        return this;
    }

    public void change() {
        this.input = this.input.replace("  ", " %space%");
        String[] stringArray = this.input.split(" ");
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stringArray[i] = stringArray[i].replace("%space%", " ");
        }
        this.splittedInput = new ArrayList<String>(Arrays.asList(stringArray));
        Node<String> node = this.group.getRootTabNode();
        if (this.splittedInput.size() == 1 && !this.plHidePlayer.unblockPluginNamedCommandsTabcomplete()) {
            this.suggestionList.removeIf(string -> string.contains(":"));
        }
        if (this.plHidePlayer.getGroupModeTabcomplete() == GroupMode.WHITELIST) {
            this.applyWhitelist(node);
        } else {
            this.applyBlacklist(node);
        }
    }

    private void applyWhitelist(Node<String> node) {
        if (this.splittedInput.isEmpty()) {
            if (node.hasChildren() && !node.containsChildren("*")) {
                this.suggestionList.removeIf(string -> !node.containsChildren(string.toLowerCase(Locale.ROOT)));
            }
            return;
        }
        String string2 = this.splittedInput.remove(0);
        if (node.hasChildren()) {
            if (node.containsChildren("~")) {
                this.suggestionList.clear();
            } else if (node.containsChildren(string2)) {
                this.applyWhitelist(node.getChild(string2));
            } else if (node.containsChildren("*")) {
                this.applyWhitelist(node.getChild("*"));
            } else {
                this.suggestionList.removeIf(string -> !node.containsChildren(string.toLowerCase(Locale.ROOT)));
            }
        }
    }

    private void applyBlacklist(Node<String> node) {
        if (this.splittedInput.size() == 0) {
            if (node.hasChildren()) {
                this.removeNotContainingSuggestion(node);
            } else {
                this.suggestionList.clear();
            }
            return;
        }
        if (node.isRoot()) {
            if (this.splittedInput.size() == 1 && !this.input.endsWith(" ")) {
                if (node.hasChildren()) {
                    this.removeNotContainingSuggestion(node);
                }
                return;
            }
            if (!node.hasChildren()) {
                return;
            }
        }
        String string = this.splittedInput.remove(0);
        if (node.hasChildren()) {
            if (node.containsChildren(string)) {
                this.applyBlacklist(node.getChild(string));
            } else if (this.splittedInput.size() == 0) {
                this.removeNotContainingSuggestion(node);
            } else if (node.containsChildren("*")) {
                this.applyBlacklist(node.getChild("*"));
            }
        } else {
            this.suggestionList.clear();
        }
    }

    private void removeNotContainingSuggestion(Node<String> node) {
        if (node.containsChildren("*") && !node.getChild("*").hasChildren()) {
            this.suggestionList.clear();
            return;
        }
        this.suggestionList.removeIf(string -> {
            if (node.containsChildren(string = string.toLowerCase(Locale.ROOT))) {
                return !node.getChild((String)string).hasChildren();
            }
            return false;
        });
    }
}

