/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.miscellaneous;

import eu.nononitas.plhidepro.spigot.PlHideProSpigot;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigHandler {
    private final File file;
    private final FileConfiguration configuration;
    private final PlHideProSpigot plHide;

    public ConfigHandler(File file, PlHideProSpigot plHideProSpigot) {
        this.plHide = plHideProSpigot;
        this.file = file;
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
    }

    public boolean exists() {
        return this.plHide.getPlugin().getDataFolder().exists() && this.file.exists();
    }

    public void save() {
        try {
            if (!this.plHide.getPlugin().getDataFolder().exists()) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.configuration.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void reload() {
        try {
            this.configuration.load(this.file);
        }
        catch (IOException | InvalidConfigurationException throwable) {
            throwable.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfiguration() {
        return this.configuration;
    }
}

