/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.miscellaneous;

public enum NMS_Version {
    UNSUPPORTED(0, 0),
    V1_17_AND_LOWER(18, 0),
    V1_18(18, 0),
    V1_19_R1(19, 0),
    V1_19_R2(19, 1),
    V1_19_R3(19, 2),
    V1_20_R1(20, 0),
    V1_20_R2(20, 1),
    V1_20_R3(20, 2);

    private final int baseVersion;
    private final int fixVersion;

    private NMS_Version(int n2, int n3) {
        this.baseVersion = n2;
        this.fixVersion = n3;
    }

    public static boolean isLegacy(String string) {
        return string.equals("1.8.8-R0.1-SNAPSHOT") || string.startsWith("1.9.") || string.equals("1.10.2-R0.1-SNAPSHOT") || string.startsWith("1.11") || string.startsWith("1.12");
    }

    public static NMS_Version fromBukkitVersion(String string) {
        if (string.startsWith("1.8.8-R0") || string.startsWith("1.9.") || string.equals("1.10.2-R0.1") || string.startsWith("1.11") || string.startsWith("1.12") || string.startsWith("1.13") || string.startsWith("1.14") || string.startsWith("1.15") || string.startsWith("1.16") || string.startsWith("1.17")) {
            return V1_17_AND_LOWER;
        }
        String[] stringArray = string.split("-");
        switch (stringArray[0]) {
            case "1.18": 
            case "1.18.1": 
            case "1.18.2": {
                return V1_18;
            }
            case "1.19": 
            case "1.19.1": 
            case "1.19.2": {
                return V1_19_R1;
            }
            case "1.19.3": {
                return V1_19_R2;
            }
            case "1.19.4": {
                return V1_19_R3;
            }
            case "1.20": 
            case "1.20.1": {
                return V1_20_R1;
            }
            case "1.20.2": {
                return V1_20_R2;
            }
            case "1.20.4": {
                return V1_20_R3;
            }
        }
        return UNSUPPORTED;
    }

    public boolean isHigherThan(NMS_Version nMS_Version) {
        if (this.baseVersion > nMS_Version.baseVersion) {
            return true;
        }
        if (this.baseVersion == nMS_Version.baseVersion) {
            return this.fixVersion > nMS_Version.fixVersion;
        }
        return false;
    }
}

