/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.miscellaneous;

import eu.nononitas.plhidepro.spigot.PlHideProSpigot;
import eu.nononitas.plhidepro.util.PluginCommandsInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class PluginMessageHandler
implements PluginMessageListener {
    private final PlHideProSpigot plhide;
    private BukkitTask task;

    public PluginMessageHandler(PlHideProSpigot plHideProSpigot) {
        this.plhide = plHideProSpigot;
    }

    public void onPluginMessageReceived(@NotNull String string, @NotNull Player player, @NotNull byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
            String string2 = objectInputStream.readUTF();
            if (string2.equals("suggestion_packet")) {
                if (this.plhide.isLegacy()) {
                    return;
                }
                if (objectInputStream.available() <= 0) {
                    return;
                }
                String string3 = objectInputStream.readUTF();
                Player player2 = Bukkit.getPlayer((String)string3);
                if (player2 != null) {
                    this.plhide.getLogger().debug("Updated command for " + string3);
                    player2.updateCommands();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendPluginCommands(Player player) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = PluginMessageHandler.generateID(player);
        try (ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            HashMap<String, HashSet<String>> hashMap = PluginCommandsInfo.getPluginCommandsHashMap();
            objectOutputStream.writeObject(hashMap);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            List<byte[]> list = PluginMessageHandler.splitByteArray(byArray, 31000);
            boolean bl = true;
            int n = 0;
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream2);
            for (byte[] byArray2 : list) {
                objectOutputStream2.writeUTF("plugin_commands");
                objectOutputStream2.writeUTF(string);
                if (bl) {
                    objectOutputStream2.writeUTF("l:" + list.size());
                    bl = false;
                }
                objectOutputStream2.writeUTF("i:" + n);
                objectOutputStream2.flush();
                objectOutputStream2.write(byArray2);
                objectOutputStream2.flush();
                player.sendPluginMessage((Plugin)this.plhide.getPlugin(), "plhidepro:tab", byteArrayOutputStream2.toByteArray());
                ++n;
                byteArrayOutputStream2.reset();
                objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendUpdateGroupRequest(Player player) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeUTF("group_update");
            objectOutputStream.writeUTF(player.getUniqueId().toString());
            objectOutputStream.flush();
            player.sendPluginMessage((Plugin)this.plhide.getPlugin(), "plhidepro:tab", byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static List<byte[]> splitByteArray(byte[] byArray, int n) {
        int n2 = byArray.length;
        int n3 = (int)Math.ceil((double)n2 / (double)n);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = Math.min(n2, n4 + n);
            byte[] byArray2 = Arrays.copyOfRange(byArray, n4, n5);
            arrayList.add(byArray2);
            n4 += n;
        }
        return arrayList;
    }

    private static String generateID(Player player) {
        long l = System.currentTimeMillis();
        int n = (int)(Math.random() * 10000.0);
        return l + "-" + n + "-" + player.getUniqueId();
    }

    public void startPluginCommandsTask() {
        if (this.task != null) {
            throw new IllegalStateException("Task is already started");
        }
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plhide.getPlugin(), (Runnable)new RetryRunnable(), 0L, 144000L);
    }

    public void disableTask() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    private class RetryRunnable
    implements Runnable {
        private int tries;

        public RetryRunnable() {
            this(0);
        }

        public RetryRunnable(int n) {
            this.tries = n;
        }

        @Override
        public void run() {
            Collection collection = Bukkit.getOnlinePlayers();
            if (collection.isEmpty()) {
                if (this.tries < 10) {
                    ++this.tries;
                    long l = Math.min(2400L, (long)this.tries * 20L * 30L);
                    PluginMessageHandler.this.plhide.getLogger().debug("[Messenger] Can't send data to the Proxy. Retrying in " + l / 20L + " seconds");
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PluginMessageHandler.this.plhide.getPlugin(), (Runnable)new RetryRunnable(this.tries), l);
                } else {
                    PluginMessageHandler.this.plhide.getLogger().debug("[Messenger] Couldn't send data to the Proxy. Stop sending");
                }
                return;
            }
            Player player = (Player)collection.stream().findFirst().get();
            PluginMessageHandler.this.sendPluginCommands(player);
            PluginMessageHandler.this.task.cancel();
            PluginMessageHandler.this.task = null;
            PluginMessageHandler.this.plhide.getLogger().debug("[Messenger] Plugin-data successfully sent");
        }
    }
}

