/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.velocity;

import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import dev.simplix.protocolize.api.Protocolize;
import dev.simplix.protocolize.api.listener.AbstractPacketListener;
import eu.nononitas.plhidepro.PlHidePlayerManagerImpl;
import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.PlHideProvider;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.Library;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.VelocityLibraryManager;
import eu.nononitas.plhidepro.libs.org.bstats.velocity.Metrics;
import eu.nononitas.plhidepro.miscellaneous.CommandsListManager;
import eu.nononitas.plhidepro.miscellaneous.Database;
import eu.nononitas.plhidepro.miscellaneous.DebugLogger;
import eu.nononitas.plhidepro.miscellaneous.IConfig;
import eu.nononitas.plhidepro.miscellaneous.ILogger;
import eu.nononitas.plhidepro.miscellaneous.LuckPermsListener;
import eu.nononitas.plhidepro.util.Updater;
import eu.nononitas.plhidepro.velocity.PlHideVelocityCmd;
import eu.nononitas.plhidepro.velocity.impl.Logger;
import eu.nononitas.plhidepro.velocity.impl.VelocityConfig;
import eu.nononitas.plhidepro.velocity.listener.BrandChannelListener;
import eu.nononitas.plhidepro.velocity.listener.CommandHandler;
import eu.nononitas.plhidepro.velocity.listener.JoinLeaveListener;
import eu.nononitas.plhidepro.velocity.listener.SuggestionListener;
import eu.nononitas.plhidepro.velocity.listener.TabCompleteRequestListener;
import eu.nononitas.plhidepro.velocity.listener.TabCompleteResponseListener;
import eu.nononitas.plhidepro.velocity.listener.VelocityPluginMessageHandler;
import eu.nononitas.plhidepro.velocity.miscellaneous.ConfigHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

@Plugin(id="pl-hide-pro", name="Pl-Hide-Pro", version="2.8.1", authors={"Nononitas"}, dependencies={@Dependency(id="protocolize"), @Dependency(id="luckperms", optional=true)})
public class PlHideProVelocity
implements PlHidePro {
    public static final String PREFIX = "\u00a73Pl\u00a77-\u00a73Hide\u00a77-\u00a76Pro\u00a77-\u00a79Velocity \u00a78\u258e \u00a7r";
    private static final int CONFIG_VERSION = 6;
    private final ProxyServer server;
    private final org.slf4j.Logger baseLogger;
    private final File dataFolder;
    private final PluginDescription pluginDescription;
    private final VelocityPluginMessageHandler pluginMessageHandler = new VelocityPluginMessageHandler(this);
    private final CommandsListManager listManager = new CommandsListManager(this);
    private ILogger logger;
    private static PlHideProVelocity instance;
    private ConfigHandler configHandler;
    private final Metrics.Factory metricsFactory;
    private final HashMap<UUID, String> playerCurrentServerMap = new HashMap();
    private IConfig config;
    private boolean hasLuckPerms;
    private DebugLogger debugLogger;
    private Database database;

    @Inject
    public PlHideProVelocity(ProxyServer proxyServer, org.slf4j.Logger logger, @DataDirectory Path path, PluginDescription pluginDescription, Metrics.Factory factory) {
        this.server = proxyServer;
        this.baseLogger = logger;
        this.metricsFactory = factory;
        this.dataFolder = path.getParent().resolve("Pl-Hide-Pro").toFile();
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        this.pluginDescription = pluginDescription;
        instance = this;
    }

    public boolean checkGroups() {
        ConfigurationNode configurationNode2 = this.getRootConfigurationNode().getNode(new Object[]{"groups"});
        ILogger iLogger = this.getLogger();
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        if (configurationNode2.getNode(new Object[]{"default"}).isVirtual()) {
            iLogger.error("default group is missing");
            atomicBoolean.set(false);
        }
        configurationNode2.getChildrenMap().forEach((object, configurationNode) -> {
            if (configurationNode.getNode(new Object[]{"servers", "all", "commands"}).isVirtual() && configurationNode.getNode(new Object[]{"servers", "fallback", "commands"}).isVirtual()) {
                iLogger.error("A fallback or \"all\" list is missing at the commands section in group " + object + ". Please add one of the lists mentioned");
                atomicBoolean.set(false);
            }
            if (configurationNode.getNode(new Object[]{"servers", "all", "tabcomplete"}).isVirtual() && configurationNode.getNode(new Object[]{"servers", "fallback", "tabcomplete"}).isVirtual()) {
                iLogger.error("A fallback or \"all\" list is missing at the tabcomplete section in group " + object + ". Please add one of the lists mentioned");
                atomicBoolean.set(false);
            }
            if (configurationNode.getNode(new Object[]{"priority"}).isVirtual()) {
                iLogger.error("The option priority is missing for the group " + object);
                atomicBoolean.set(false);
            }
            if (configurationNode.getNode(new Object[]{"blocked-command-message"}).isVirtual()) {
                iLogger.error("The option blocked-command-message is missing for the group " + object);
                atomicBoolean.set(false);
            }
            if (configurationNode.getNode(new Object[]{"enabled_servers"}).isVirtual()) {
                iLogger.error("The list enabled_servers is missing for the group " + object);
                atomicBoolean.set(false);
            }
            if (configurationNode.getNode(new Object[]{"inherited-groups"}).isVirtual()) {
                iLogger.error("The option inherited-groups is missing for the group " + object);
                atomicBoolean.set(false);
            }
        });
        return atomicBoolean.get();
    }

    public ProxyServer getServer() {
        return this.server;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public IConfig getConfig() {
        return this.config;
    }

    @Override
    public IConfig getConfig(File file) {
        return new VelocityConfig(file);
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    public ConfigurationNode getRootConfigurationNode() {
        return this.configHandler.getConfiguration();
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public PluginDescription getPluginDescription() {
        return this.pluginDescription;
    }

    public static PlHideProVelocity getInstance() {
        return instance;
    }

    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent proxyInitializeEvent) {
        Updater.currentVersion = (String)this.getPluginDescription().getVersion().get();
        PlHideProvider.setPlHidePro(this);
        this.configHandler = new ConfigHandler(new File(this.getDataFolder(), "config.yml"));
        this.loadConfig();
        this.debugLogger = new DebugLogger(this.getDataFolder().getPath(), this.getRootConfigurationNode().getNode(new Object[]{"debug"}).getBoolean());
        this.logger = new Logger(this.baseLogger, this.debugLogger);
        if (!this.updateConfig()) {
            this.getLogger().error("Config update failed. Disabling Plugin");
            return;
        }
        VelocityLibraryManager<PlHideProVelocity> velocityLibraryManager = new VelocityLibraryManager<PlHideProVelocity>(((Logger)this.getLogger()).getBaseLogger(), this.getDataFolder().toPath(), this.getServer().getPluginManager(), this, "libs");
        Library library = Library.builder().groupId("org{}xerial").artifactId("sqlite-jdbc").version("3.45.0.0").id("sqlite").relocate("org{}xerial", "eu{}nononitas{}plhidepro{}libs{}org{}xerial").isolatedLoad(false).build();
        velocityLibraryManager.addMavenCentral();
        velocityLibraryManager.loadLibrary(library);
        this.listManager.loadLists();
        this.checkGroups();
        this.database = new Database(this.getDataFolder().toPath(), this);
        this.server.getEventManager().register((Object)this, (Object)new SuggestionListener(this));
        this.server.getEventManager().register((Object)this, (Object)new JoinLeaveListener(this));
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)"plhidepro:tab")});
        this.server.getEventManager().register((Object)this, (Object)this.pluginMessageHandler);
        this.server.getCommandManager().register("plhide-velocity", (Command)new PlHideVelocityCmd(this), new String[0]);
        Protocolize.listenerProvider().registerListener((AbstractPacketListener)new TabCompleteRequestListener());
        Protocolize.listenerProvider().registerListener((AbstractPacketListener)new TabCompleteResponseListener(this));
        Protocolize.listenerProvider().registerListener((AbstractPacketListener)new BrandChannelListener(this));
        CommandHandler commandHandler = new CommandHandler(this);
        Protocolize.listenerProvider().registerListener((AbstractPacketListener)new CommandHandler.KeyedCommandListener(commandHandler));
        Protocolize.listenerProvider().registerListener((AbstractPacketListener)new CommandHandler.SessionCommandListener(commandHandler));
        Protocolize.listenerProvider().registerListener((AbstractPacketListener)new CommandHandler.LegacyCommandListener(commandHandler));
        this.metricsFactory.make(this, 12655);
        this.getServer().getScheduler().buildTask((Object)PlHideProVelocity.getInstance(), () -> Updater.updatecheck(false).ifPresent(string -> this.getLogger().info((String)string))).schedule();
    }

    @Subscribe(order=PostOrder.LAST)
    public void onProxyInitializationLast(ProxyInitializeEvent proxyInitializeEvent) {
        if (this.server.getPluginManager().isLoaded("luckperms")) {
            this.hasLuckPerms = true;
            LuckPermsListener.init(this);
        }
    }

    @Subscribe
    public void onDisable(ProxyShutdownEvent proxyShutdownEvent) {
        this.database.closeConnection();
        this.debugLogger.close();
    }

    public void loadConfig() {
        if (!this.configHandler.exists()) {
            this.configHandler.createDefaultFile("config-velocity.yml");
        }
        this.configHandler.load();
        this.config = new VelocityConfig(this.configHandler.getConfiguration());
    }

    public boolean updateConfig() {
        Object object2;
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        ILogger iLogger = this.getLogger();
        int n = 6;
        File file = new File(this.getDataFolder(), "config_with_explanations.yml");
        try (InputStream inputStream = PlHideProVelocity.class.getResourceAsStream("/config-velocity.yml");){
            object2 = new FileOutputStream(file);
            try {
                file.createNewFile();
                ByteStreams.copy((InputStream)inputStream, (OutputStream)object2);
            }
            finally {
                ((OutputStream)object2).close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n2 = this.getRootConfigurationNode().getNode(new Object[]{"version"}).getInt();
        object2 = this.getDataFolder();
        File file2 = new File((File)object2, "backups");
        if (n2 < n) {
            file2.mkdir();
            try {
                iLogger.warn("\u00a73Pl\u00a77-\u00a73Hide\u00a77-\u00a76Pro \u00a78\u258e \u00a7r\u00a7eNew config version available. Creating backup with the name \u00a7cconfig-old-" + n2 + ".yml in the backups folder");
                Files.copy(Paths.get((File)object2 + "/config.yml", new String[0]), Paths.get(file2 + "/config-old-" + n2 + ".yml", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ConfigurationNode configurationNode2 = this.getRootConfigurationNode();
            while (n2 < n) {
                switch (n2) {
                    case 1: {
                        configurationNode2.removeChild((Object)"block-plugin-named-commands-tabcomplete");
                        configurationNode2.removeChild((Object)"block-plugin-named-commands-execution");
                        configurationNode2.getNode(new Object[]{"groups"}).getChildrenMap().forEach((object, configurationNode) -> {
                            configurationNode.removeChild((Object)"group-mode-commands");
                            configurationNode.removeChild((Object)"group-mode-tabcomplete");
                        });
                        break;
                    }
                    case 2: {
                        configurationNode2.getNode(new Object[]{"f3-server-brand"}).setValue((Object)"&3Plugin&7-&3Hide&7-&6Pro");
                        configurationNode2.getNode(new Object[]{"replace-f3-server-brand"}).setValue((Object)true);
                        break;
                    }
                    case 3: {
                        configurationNode2.getNode(new Object[]{"groups"}).getChildrenMap().forEach((object, configurationNode) -> {
                            List list;
                            try {
                                list = configurationNode.getNode(new Object[]{"included-groups"}).getList(TypeToken.of(String.class));
                            }
                            catch (ObjectMappingException objectMappingException) {
                                objectMappingException.printStackTrace();
                                atomicBoolean.set(false);
                                return;
                            }
                            configurationNode.removeChild((Object)"included-groups");
                            configurationNode.getNode(new Object[]{"inherited-groups"}).setValue((Object)list);
                        });
                        break;
                    }
                    case 4: {
                        configurationNode2.getNode(new Object[]{"groups"}).getChildrenMap().forEach((object, configurationNode) -> {
                            List list;
                            List list2;
                            List list3;
                            try {
                                list3 = configurationNode.getNode(new Object[]{"commands"}).getList(TypeToken.of(String.class));
                                list2 = configurationNode.getNode(new Object[]{"tabcomplete"}).getList(TypeToken.of(String.class));
                                list = configurationNode.getNode(new Object[]{"servers"}).getList(TypeToken.of(String.class));
                            }
                            catch (ObjectMappingException objectMappingException) {
                                objectMappingException.printStackTrace();
                                atomicBoolean.set(false);
                                return;
                            }
                            configurationNode.removeChild((Object)"commands");
                            configurationNode.removeChild((Object)"tabcomplete");
                            configurationNode.removeChild((Object)"servers");
                            configurationNode.getNode(new Object[]{"servers", "all", "commands"}).setValue((Object)list3);
                            configurationNode.getNode(new Object[]{"servers", "all", "tabcomplete"}).setValue((Object)list2);
                            configurationNode.getNode(new Object[]{"enabled_servers"}).setValue((Object)list);
                        });
                        break;
                    }
                    case 5: {
                        configurationNode2.getNode(new Object[]{"auto_lowercase_base_commands"}).setValue((Object)true);
                        Path path = Paths.get(this.getDataFolder().toPath().resolve("lists.yml").toUri());
                        Path path2 = this.getDataFolder().toPath().resolve("lists");
                        path2.toFile().mkdirs();
                        Path path3 = Paths.get(path2.resolve("lists.yml").toUri());
                        try {
                            Files.move(path, path3, StandardCopyOption.REPLACE_EXISTING);
                            break;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            this.getLogger().error("Automatically migrating the lists.yml failed. Please move the lists.yml manually into the lists folder!");
                        }
                    }
                }
                configurationNode2.getNode(new Object[]{"version"}).setValue((Object)(++n2));
                this.getConfigHandler().save();
            }
        }
        return atomicBoolean.get();
    }

    public HashMap<UUID, String> getPlayerCurrentServerMap() {
        return this.playerCurrentServerMap;
    }

    public VelocityPluginMessageHandler getPluginMessageHandler() {
        return this.pluginMessageHandler;
    }

    public boolean hasLuckPerms() {
        return this.hasLuckPerms;
    }

    @Override
    public PlHidePlayerManagerImpl getPlayerManager() {
        return PlHidePro.super.getPlayerManager();
    }

    @Override
    public CommandsListManager getListManager() {
        return this.listManager;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }
}

