/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.velocity.listener;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import dev.simplix.protocolize.api.Direction;
import dev.simplix.protocolize.api.listener.AbstractPacketListener;
import dev.simplix.protocolize.api.listener.PacketReceiveEvent;
import dev.simplix.protocolize.api.listener.PacketSendEvent;
import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.util.ByteBufSerializer;
import eu.nononitas.plhidepro.velocity.PlHideProVelocity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class BrandChannelListener
extends AbstractPacketListener<PluginMessagePacket> {
    private final PlHideProVelocity plhide;

    public BrandChannelListener(PlHideProVelocity plHideProVelocity) {
        super(PluginMessagePacket.class, Direction.UPSTREAM, 1);
        this.plhide = plHideProVelocity;
    }

    public static PluginMessagePacket createBrandPacket(Player player, String string) {
        String string2 = player.getProtocolVersion().getProtocol() < 393 ? "MC|Brand" : "minecraft:brand";
        String string3 = PlHideProVelocity.getInstance().getRootConfigurationNode().getNode(new Object[]{"f3-server-brand"}).getString();
        if (string3 == null) {
            string3 = "";
        }
        if (string != null) {
            string3 = string3.replace("%server%", string);
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])ByteBufSerializer.getByteArray(PlHidePro.translateColor(string3) + "\u00a7r"));
        return new PluginMessagePacket(string2, byteBuf);
    }

    public void packetReceive(PacketReceiveEvent<PluginMessagePacket> packetReceiveEvent) {
    }

    public void packetSend(PacketSendEvent<PluginMessagePacket> packetSendEvent) {
        String string = ((PluginMessagePacket)packetSendEvent.packet()).getChannel();
        if (this.plhide.getRootConfigurationNode().getNode(new Object[]{"replace-f3-server-brand"}).getBoolean() && (string.equals("MC|Brand") || string.equals("minecraft:brand"))) {
            if (packetSendEvent.player() == null) {
                return;
            }
            Player player = (Player)packetSendEvent.player().handle();
            String string2 = player.getCurrentServer().isPresent() ? ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName() : null;
            packetSendEvent.packet((Object)BrandChannelListener.createBrandPacket(player, string2));
        }
    }
}

