/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.velocity.listener;

import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.PlayerAvailableCommandsEvent;
import com.velocitypowered.api.proxy.Player;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.modifier.SuggestionEditor;
import eu.nononitas.plhidepro.velocity.PlHideProVelocity;
import eu.nononitas.plhidepro.velocity.impl.PlHideVelocityPlayer;

public class SuggestionListener {
    private final PlHideProVelocity plhide;

    public SuggestionListener(PlHideProVelocity plHideProVelocity) {
        this.plhide = plHideProVelocity;
    }

    @Subscribe(order=PostOrder.LATE)
    public void onPlayerAvailableCommandsEvent(PlayerAvailableCommandsEvent playerAvailableCommandsEvent) {
        Player player = playerAvailableCommandsEvent.getPlayer();
        RootCommandNode rootCommandNode = playerAvailableCommandsEvent.getRootNode();
        if (!this.plhide.getPlayerManager().isRegistered(player)) {
            rootCommandNode.getChildren().clear();
            this.plhide.getLogger().warn(String.format("Received a commands suggestion request from %s even though he is not registered. Aborting request", player.getUsername()));
            return;
        }
        PlHideVelocityPlayer plHideVelocityPlayer = (PlHideVelocityPlayer)this.plhide.getPlayerManager().getPlHidePlayer(player);
        IGroup iGroup = plHideVelocityPlayer.getGroup();
        if (iGroup.getGroupNames() != null) {
            SuggestionEditor.editSuggestion(rootCommandNode, plHideVelocityPlayer);
        }
    }
}

