/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.api;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPvpPlayerLog;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.param.GuildPvpPlayerParam;
import com.handy.guild.param.GuildSeasonPvpPlayerParam;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPvpPlayerLogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class PlayerGuildApi {
    private PlayerGuildApi() {
    }

    public static PlayerGuildApi getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean giveGuildMoneyByName(String guildName, int money) {
        return GuildInfoService.getInstance().addMoneyByName(guildName, money);
    }

    public boolean takeGuildMoneyByName(String guildName, int money) {
        return GuildInfoService.getInstance().subtractMoneyByName(guildName, money);
    }

    public boolean setGuildMoneyByName(String guildName, int money) {
        return GuildInfoService.getInstance().setMoneyByName(guildName, money);
    }

    public boolean giveGuildProsperityDegreeByName(String guildName, int money) {
        return GuildInfoService.getInstance().addProsperityDegreeByName(guildName, money);
    }

    public boolean takeGuildProsperityDegreeByName(String guildName, int money) {
        return GuildInfoService.getInstance().subtractProsperityDegreeByName(guildName, money);
    }

    public boolean setGuildProsperityDegreeByName(String guildName, int money) {
        return GuildInfoService.getInstance().setProsperityDegreeByName(guildName, money);
    }

    public boolean giveGuildOreByName(String guildName, int money) {
        return GuildInfoService.getInstance().addOreByName(guildName, money);
    }

    public boolean takeGuildOreByName(String guildName, int money) {
        return GuildInfoService.getInstance().subtractOreByName(guildName, money);
    }

    public boolean setGuildOreByName(String guildName, int money) {
        return GuildInfoService.getInstance().setOreByName(guildName, money);
    }

    public boolean givePlayerMoneyByName(String playerName, int money) {
        return GuildPlayerService.getInstance().addMoneyByName(playerName, money);
    }

    public boolean takePlayerMoneyByName(String playerName, int money) {
        return GuildPlayerService.getInstance().subtractMoneyByName(playerName, money);
    }

    public boolean setPlayerMoneyByName(String playerName, int money) {
        return GuildPlayerService.getInstance().setMoneyByName(playerName, money);
    }

    public boolean givePlayerMoneyByName(Player player, int money) {
        return this.givePlayerMoneyByName(player.getName(), money);
    }

    public boolean takePlayerMoneyByName(Player player, int money) {
        return this.takePlayerMoneyByName(player.getName(), money);
    }

    public boolean setPlayerMoneyByName(Player player, int money) {
        return this.setPlayerMoneyByName(player.getName(), money);
    }

    public String getPlayerGuildName(Player player) {
        return this.getPlayerGuildName(player.getName());
    }

    public String getPlayerGuildName(String playerName) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(playerName);
        return guildPlayerOptional.map(GuildPlayer::getGuildInfoName).orElse(null);
    }

    public Integer getPlayerMoney(Player player) {
        return this.getPlayerMoney(player.getName());
    }

    public Integer getPlayerMoney(String playerName) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(playerName);
        return guildPlayerOptional.isPresent() ? guildPlayerOptional.get().getMoney() : 0;
    }

    public Integer getPlayerGuildMoney(Player player) {
        return this.getPlayerGuildMoney(player.getName());
    }

    public Integer getPlayerGuildMoney(String playerName) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(playerName);
        return guildPlayerOptional.isPresent() ? guildPlayerOptional.get().getGuildMoney() : 0;
    }

    public List<String> getPlayerGuildMember(Player player) {
        return this.getPlayerGuildMember(player.getName());
    }

    public List<String> getPlayerGuildMember(String playerName) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(playerName);
        if (!guildPlayerOptional.isPresent()) {
            return new ArrayList<String>();
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildPlayer.getGuildInfoId());
        return guildPlayerList.stream().map(GuildPlayer::getPlayerName).collect(Collectors.toList());
    }

    public String getPlayerGuildRole(Player player) {
        return this.getPlayerGuildRole(player.getName());
    }

    public String getPlayerGuildRole(String playerName) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(playerName);
        return guildPlayerOptional.isPresent() ? GuildRoleEnum.getRoleName(guildPlayerOptional.get().getRoleId()) : BaseUtil.getLangMsg("role.not", "");
    }

    public Integer getPlayerKill(Player player) {
        return this.getPlayerKill(player.getName());
    }

    public Integer getPlayerKill(String playerName) {
        List<GuildPvpPlayerLog> guildPvpPlayerLogs = GuildPvpPlayerLogService.getInstance().findByPlayerName(playerName);
        Integer kill = 0;
        if (CollUtil.isNotEmpty(guildPvpPlayerLogs)) {
            List killList = guildPvpPlayerLogs.stream().map(GuildPvpPlayerLog::getKill).collect(Collectors.toList());
            for (Integer killNumber : killList) {
                kill = kill + killNumber;
            }
        }
        return kill;
    }

    public Integer getPlayerDie(Player player) {
        return this.getPlayerDie(player.getName());
    }

    public Integer getPlayerDie(String playerName) {
        List<GuildPvpPlayerLog> guildPvpPlayerLogs = GuildPvpPlayerLogService.getInstance().findByPlayerName(playerName);
        Integer die = 0;
        if (CollUtil.isNotEmpty(guildPvpPlayerLogs)) {
            List dieList = guildPvpPlayerLogs.stream().map(GuildPvpPlayerLog::getDie).collect(Collectors.toList());
            for (Integer number : dieList) {
                die = die + number;
            }
        }
        return die;
    }

    public boolean isPvp(Player player) {
        if (this.matchStart(player)) {
            return true;
        }
        if (this.matchPreparation(player)) {
            return true;
        }
        if (this.seasonPreparation(player)) {
            return true;
        }
        return this.seasonStart(player);
    }

    public void closePvp(Player player) {
        GuildConstants.PLAYER_API_PVP_MAP.put(player.getUniqueId(), true);
    }

    public void openPvp(Player player) {
        GuildConstants.PLAYER_API_PVP_MAP.remove(player.getUniqueId());
    }

    public List<UUID> getMatchStartPlayer(Integer guildId) {
        if (MatchConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return new ArrayList<UUID>();
        }
        List<GuildPvpPlayerParam> guildPvpPlayerParams = MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId);
        if (CollUtil.isEmpty(guildPvpPlayerParams)) {
            return new ArrayList<UUID>();
        }
        return guildPvpPlayerParams.stream().map(GuildPvpPlayerParam::getPlayerUuid).filter(s -> MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(s) != null).collect(Collectors.toList());
    }

    public List<UUID> getSeasonStartPlayer(Integer guildId) {
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return new ArrayList<UUID>();
        }
        List<GuildSeasonPvpPlayerParam> guildSeasonPvpPlayerParams = SeasonConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId);
        if (CollUtil.isEmpty(guildSeasonPvpPlayerParams)) {
            return new ArrayList<UUID>();
        }
        return guildSeasonPvpPlayerParams.stream().map(GuildSeasonPvpPlayerParam::getPlayerUuid).filter(s -> SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(s) != null).collect(Collectors.toList());
    }

    public List<String> getAllGuildName() {
        List<GuildInfo> guildInfoList = GuildInfoService.getInstance().findAll();
        return guildInfoList.stream().map(GuildInfo::getGuildName).collect(Collectors.toList());
    }

    public List<String> getGuildPlayer(String guildName) {
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildName(guildName);
        return guildPlayerList.stream().map(GuildPlayer::getPlayerName).collect(Collectors.toList());
    }

    private boolean matchStart(Player player) {
        if (MatchConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return false;
        }
        Integer guildId = MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(player.getUniqueId());
        return guildId != null;
    }

    private boolean matchPreparation(Player player) {
        if (MatchConstants.GUILD_PVP_PREPARATION_MAP.isEmpty()) {
            return false;
        }
        for (Integer guildId : MatchConstants.GUILD_PVP_PREPARATION_MAP.keySet()) {
            List<UUID> uuids = MatchConstants.GUILD_PVP_PREPARATION_MAP.get(guildId);
            if (!uuids.contains(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    private boolean seasonStart(Player player) {
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return false;
        }
        Integer guildId = SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(player.getUniqueId());
        return guildId != null;
    }

    private boolean seasonPreparation(Player player) {
        if (SeasonConstants.GUILD_PVP_PREPARATION_MAP.isEmpty()) {
            return false;
        }
        for (Integer guildId : SeasonConstants.GUILD_PVP_PREPARATION_MAP.keySet()) {
            List uuids = SeasonConstants.GUILD_PVP_PREPARATION_MAP.getOrDefault(guildId, new ArrayList());
            if (!uuids.contains(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    private static class SingletonHolder {
        private static final PlayerGuildApi INSTANCE = new PlayerGuildApi();

        private SingletonHolder() {
        }
    }
}

