/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.hook.WorldUtil;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class AdminEditGuildNameCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "adminEditGuildName";
    }

    @Override
    public String permission() {
        return "playerGuild.adminEditGuildName";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String oldGuildName = args[1];
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findByGuildName(oldGuildName);
        AssertUtil.notTrue(!guildInfoOptional.isPresent(), sender, BaseUtil.getMsgNotColor("joinFailureMsg"));
        GuildInfo guildInfo = guildInfoOptional.get();
        String newGuildName = args[2];
        Optional<GuildInfo> infoOptional = GuildInfoService.getInstance().findByGuildName(newGuildName);
        AssertUtil.notTrue(infoOptional.isPresent(), sender, ConfigUtil.CREATE_CONFIG.getString("duplicateName"));
        String replaceGuildName = newGuildName.replace("\u00a7", "&");
        GuildInfoService.getInstance().editGuildName(guildInfo.getId(), replaceGuildName, 0);
        WorldUtil.setWorldAlias(guildInfo.getWorldName(), replaceGuildName);
        PlayerTitleUtil.setGuildTitle(guildInfo.getId());
        String editNameOkButton = ConfigUtil.SETTING_CONFIG.getString("editName.okButton", "").replace("${guildName}", newGuildName);
        MessageUtil.sendMessage(sender, editNameOkButton);
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildInfo.getId());
        for (GuildPlayer guildPlayer : guildPlayerList) {
            UUID uuid = UUID.fromString(guildPlayer.getPlayerUuid());
            if (!GuildConstants.PLAYER_GUILD_MAP.containsKey(uuid)) continue;
            GuildConstants.PLAYER_GUILD_MAP.put(uuid, guildPlayer);
        }
    }
}

