/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildLogo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.service.GuildPlayerService;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveLogoCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "giveLogo";
    }

    @Override
    public String permission() {
        return "playerGuild.giveLogo";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        Integer guildId;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        String name = args[1];
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
        ItemStack clone = itemInMainHand.clone();
        clone.setAmount(1);
        if ("${guildName}".equalsIgnoreCase(name)) {
            if (BaseUtil.isNotPlayer(sender).booleanValue()) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
                return;
            }
            Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!guildPlayerOptional.isPresent()) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noGuildMsg"));
                return;
            }
            guildId = guildPlayerOptional.get().getGuildInfoId();
        } else {
            Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findByGuildName(name);
            if (!guildInfoOptional.isPresent()) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noGuildMsg"));
                return;
            }
            guildId = guildInfoOptional.get().getId();
        }
        GuildLogoService.getInstance().updateUseToFalse(guildId);
        GuildLogo guildLogo = new GuildLogo();
        guildLogo.setGuildInfoId(guildId);
        guildLogo.setLogoId(-1);
        guildLogo.setLogoName(ItemStackUtil.itemStackSerialize(clone));
        guildLogo.setUseFlag(true);
        int rst = GuildLogoService.getInstance().add(guildLogo);
        GuildInfoService.getInstance().updateLogoById(guildId, -1, ItemStackUtil.itemStackSerialize(clone));
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst > 0 ? "succeedMsg" : "failureMsg"));
    }
}

