/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.enter.GuildPlayerItem;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerItemService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RestoreCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "restore";
    }

    @Override
    public String permission() {
        return "playerGuild.restore";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        String playerName = args[1].trim();
        List<GuildPlayerItem> guildPlayerItems = GuildPlayerItemService.getInstance().findByPlayerName(playerName);
        if (CollUtil.isEmpty(guildPlayerItems)) {
            MessageUtil.sendMessage(player, ConfigUtil.KIT_PVP_CONFIG.getString("noItem"));
            return;
        }
        for (GuildPlayerItem guildPlayerItem : guildPlayerItems) {
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(guildPlayerItem.getItemStack());
            ItemStackUtil.addItem(player.getInventory(), itemStack, itemStack.getAmount());
        }
        GuildPlayerItemService.getInstance().delByPlayerName(playerName);
        MessageUtil.sendMessage(player, ConfigUtil.KIT_PVP_CONFIG.getString("restore"));
    }
}

