/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildApply;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildPlayerService;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DenyCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "deny";
    }

    @Override
    public String permission() {
        return "playerGuild.deny";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer applyId = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        DenyCommand.deny(player, applyId);
    }

    public static synchronized void deny(Player player, Integer applyId) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        Optional<GuildApply> guildApplyOptional = GuildApplyService.getInstance().findById(applyId);
        if (!guildApplyOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noApply"));
            return;
        }
        GuildApply guildApply = guildApplyOptional.get();
        if (ApplyTypeEnum.CANCEL.getId().equals(guildApply.getApplyResult())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("joinApplyCancelMsg").replace("${player}", guildApply.getPlayerName()));
            return;
        }
        if (!ApplyTypeEnum.PENDING.getId().equals(guildApply.getApplyResult())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("refuseFailureMsg").replace("${applyPlayerName}", guildApply.getApplyPlayerName()));
            return;
        }
        guildApply.setApplyResult(ApplyTypeEnum.REFUSE.getId());
        guildApply.setApplyPlayerName(player.getName());
        guildApply.setApplyPlayerUuid(player.getUniqueId().toString());
        GuildApplyService.getInstance().updateById(guildApply);
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("refuseSucceedMsg").replace("${player}", guildApply.getPlayerName()));
        Player applyPlayer = Bukkit.getPlayer((String)guildApply.getPlayerName());
        if (applyPlayer != null && applyPlayer.isOnline()) {
            MessageUtil.sendMessage(applyPlayer, BaseUtil.getMsgNotColor("joinApplyRefuseMsg").replace("${player}", guildPlayer.getPlayerName()).replace("${guild_name}", guildPlayer.getGuildInfoName()));
        }
    }
}

