/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DenyInvitationCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "denyInvitation";
    }

    @Override
    public String permission() {
        return "playerGuild.denyInvitation";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer invitationGuildId = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        List<Integer> guildIdList = GuildConstants.INVITATION_PLAYER_MAP.get(player.getName());
        if (CollUtil.isEmpty(guildIdList) || !guildIdList.contains(invitationGuildId)) {
            MessageUtil.sendMessage(player, ConfigUtil.INVITATION_CONFIG.getString("member.noInvitation"));
            return;
        }
        guildIdList.remove(invitationGuildId);
        GuildConstants.INVITATION_PLAYER_MAP.put(player.getName(), guildIdList);
        MessageUtil.sendMessage(player, ConfigUtil.INVITATION_CONFIG.getString("member.denyMsg"));
        MessageUtil.sendMessage(args[2], ConfigUtil.INVITATION_CONFIG.getString("member.denyJoinMsg", "").replace("${player}", player.getName()));
    }
}

