/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.player;

import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.inventory.GuildCreateGui;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class CreateCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "create";
    }

    @Override
    public String permission() {
        return "playerGuild.create";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        String guildName = args[1].trim();
        CreateCommand.create(player, guildName);
    }

    public static void create(Player player, String guildName) {
        int guildNameLength = ConfigUtil.CREATE_CONFIG.getInt("guildNameLength");
        if (BaseUtil.stripColor(guildName).length() > guildNameLength) {
            String lengthFailureMsg = ConfigUtil.CREATE_CONFIG.getString("lengthFailureMsg", "").replace("${length}", guildNameLength + "");
            MessageUtil.sendMessage(player, lengthFailureMsg);
            return;
        }
        if ((guildName.contains("&") || guildName.contains("\u00a7")) && !player.hasPermission("playerguild.create.color")) {
            String colorFailureMsg = ConfigUtil.CREATE_CONFIG.getString("colorFailureMsg", "&4\u4f60\u6ca1\u6709 &aplayerguild.create.color &4\u6743\u9650\u6765\u521b\u5efa\u5f69\u8272\u540d\u79f0\u7684\u516c\u4f1a");
            MessageUtil.sendMessage(player, colorFailureMsg);
            return;
        }
        List nameBlackList = ConfigUtil.CREATE_CONFIG.getStringList("nameBlackList");
        for (String nameBlack : nameBlackList) {
            if (!guildName.contains(nameBlack)) continue;
            String nameBlackListFailureMsg = ConfigUtil.CREATE_CONFIG.getString("nameBlackListFailureMsg", "").replace("${name}", nameBlack);
            MessageUtil.sendMessage(player, nameBlackListFailureMsg);
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("haveGuild"));
            return;
        }
        Optional<GuildInfo> infoOptional = GuildInfoService.getInstance().findByGuildName(guildName);
        if (infoOptional.isPresent()) {
            MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("duplicateName"));
            return;
        }
        Inventory inventory = GuildCreateGui.getInstance().createGui(player, guildName);
        HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
    }
}

