/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.player;

import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.enter.GuildApply;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPlayerCooling;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerCoolingService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.Date;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JoinCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "join";
    }

    @Override
    public String permission() {
        return "playerGuild.join";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        String guildName = args[1];
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findByGuildName(guildName);
        if (!guildInfoOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("existGuild"));
            return;
        }
        JoinCommand.join(player, guildInfo.getId());
    }

    public static void join(Player player, Integer guildIndoId) {
        Optional<GuildApply> guildApplyOptional = GuildApplyService.getInstance().findByPlayerName(player.getName(), ApplyTypeEnum.PENDING.getId());
        if (guildApplyOptional.isPresent() && guildApplyOptional.get().getGuildInfoId().equals(guildIndoId)) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("haveApplied"));
        } else if (guildApplyOptional.isPresent()) {
            GuildApplyService.getInstance().updateApplyResultByPlayerName(player.getName(), ApplyTypeEnum.CANCEL.getId());
            GuildUtil.joinGuild(guildIndoId, player);
        } else {
            Optional<GuildPlayerCooling> guildPlayerCoolingOptional = GuildPlayerCoolingService.getInstance().findByPlayerName(player.getName());
            if (guildPlayerCoolingOptional.isPresent()) {
                GuildPlayerCooling guildPlayerCooling = guildPlayerCoolingOptional.get();
                long between = DateUtil.between(guildPlayerCooling.getLeaveTime(), new Date());
                int joinCooling = ConfigUtil.CONFIG.getInt("joinCooling", 0);
                long time = (long)joinCooling - between;
                if (time > 0L) {
                    String joinCoolingMsg = BaseUtil.getMsgNotColor("joinCoolingMsg").replace("${time}", time + "");
                    MessageUtil.sendMessage(player, joinCoolingMsg);
                } else {
                    GuildPlayerCoolingService.getInstance().delByPlayerName(player.getName());
                    GuildUtil.joinGuild(guildIndoId, player);
                }
            } else {
                GuildUtil.joinGuild(guildIndoId, player);
            }
        }
    }
}

