/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.player;

import com.handy.guild.constants.GuildSortEnum;
import com.handy.guild.constants.ShopSearchEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.inventory.GuildActivityGui;
import com.handy.guild.inventory.GuildBankGui;
import com.handy.guild.inventory.GuildMemberGui;
import com.handy.guild.inventory.GuildNoticeGui;
import com.handy.guild.inventory.GuildOpenGui;
import com.handy.guild.inventory.GuildSacredStoneGui;
import com.handy.guild.inventory.GuildShopGui;
import com.handy.guild.inventory.GuildSignInGui;
import com.handy.guild.inventory.GuildTaskGui;
import com.handy.guild.inventory.GuildTitleGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.service.GuildPlayerService;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class MeCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "me";
    }

    @Override
    public String permission() {
        return "playerGuild.me";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Inventory inventory;
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            inventory = GuildOpenGui.getInstance().createGui(player, GuildSortEnum.PROSPERITY_DEGREE.getName());
        } else {
            GuildPlayer guildPlayer = guildPlayerOptional.get();
            String type = "me";
            if (args.length > 1) {
                type = args[1];
            }
            switch (type.toLowerCase()) {
                case "activity": {
                    inventory = GuildActivityGui.getInstance().createGui(player, guildPlayer.getGuildInfoId());
                    break;
                }
                case "sacredstone": {
                    inventory = GuildSacredStoneGui.getInstance().createGui(player, guildPlayer.getGuildInfoId());
                    break;
                }
                case "signin": {
                    inventory = GuildSignInGui.getInstance().createGui(player, guildPlayer.getGuildInfoId());
                    break;
                }
                case "shop": {
                    inventory = GuildShopGui.getInstance().createGui(player, guildPlayer.getGuildInfoId(), ShopSearchEnum.ALL.getType());
                    break;
                }
                case "systemshop": {
                    inventory = GuildShopGui.getInstance().createGui(player, guildPlayer.getGuildInfoId(), ShopSearchEnum.SYSTEM.getType());
                    break;
                }
                case "playershop": {
                    inventory = GuildShopGui.getInstance().createGui(player, guildPlayer.getGuildInfoId(), ShopSearchEnum.PLAYER.getType());
                    break;
                }
                case "bank": {
                    inventory = GuildBankGui.getInstance().createGui(player, guildPlayer.getGuildInfoId());
                    break;
                }
                case "member": {
                    inventory = GuildMemberGui.getInstance().createGui(player, guildPlayer.getGuildInfoId());
                    break;
                }
                case "task": {
                    inventory = GuildTaskGui.getInstance().createGui(player, guildPlayer.getGuildInfoId());
                    break;
                }
                case "title": {
                    inventory = GuildTitleGui.getInstance().createGui(player, guildPlayer.getGuildInfoId());
                    break;
                }
                case "notice": {
                    inventory = GuildNoticeGui.getInstance().createGui(player, guildPlayer.getGuildInfoId(), "all");
                    break;
                }
                default: {
                    inventory = GuildViewGui.getInstance().createGui(player, guildPlayer.getGuildInfoId());
                }
            }
        }
        HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
    }
}

