/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.hook;

import com.handy.guild.PlayerGuild;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.playertitle.api.PlayerTitleApi;
import com.handy.playertitle.api.param.TitleBuffParam;
import com.handy.playertitle.api.param.TitleListParam;
import com.handy.playertitle.constants.BuffTypeEnum;
import com.handy.playertitle.constants.BuyTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PlayerTitleUtil {
    private PlayerTitleUtil() {
    }

    public static void createTitle(GuildInfo guildInfo) {
        if (!PlayerGuild.USE_TITLE || !ConfigUtil.TITLE_CONFIG.getBoolean("enable", true)) {
            return;
        }
        Integer guildId = guildInfo.getId();
        Integer level = guildInfo.getLevel();
        String buffType = ConfigUtil.TITLE_CONFIG.getString("buffType");
        String title = ConfigUtil.TITLE_CONFIG.getString(level + ".title");
        List description = ConfigUtil.TITLE_CONFIG.getStringList("description");
        List buffList = ConfigUtil.TITLE_CONFIG.getStringList(level + ".buff");
        List displayList = ConfigUtil.TITLE_CONFIG.getStringList(level + ".display");
        if (StrUtil.isEmpty(title)) {
            return;
        }
        title = title.replace("${guild_name}", guildInfo.getGuildName());
        TitleListParam titleListParam = new TitleListParam();
        titleListParam.setTitleName(title);
        titleListParam.setBuyTypeEnum(BuyTypeEnum.NOT);
        titleListParam.setAmount(Integer.valueOf(0));
        titleListParam.setDay(Integer.valueOf(0));
        titleListParam.setIsHide(Integer.valueOf(1));
        titleListParam.setDescription(CollUtil.listToStr(description).replace("${guild_name}", guildInfo.getGuildName()));
        titleListParam.setIsPrefixAndSuffix(Boolean.valueOf(false));
        titleListParam.setTitleBuffs(PlayerTitleUtil.getTitleBuffList(buffList, buffType, displayList));
        Long titleId = PlayerTitleApi.getInstance().add(titleListParam);
        GuildInfoService.getInstance().updateTitleIdById(guildId, titleId);
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildId);
        for (GuildPlayer guildPlayer : guildPlayerList) {
            PlayerTitleApi.getInstance().set(guildPlayer.getPlayerName(), titleId);
        }
    }

    public static void setGuildTitle(Integer guildId) {
        if (!PlayerGuild.USE_TITLE && ConfigUtil.TITLE_CONFIG.getBoolean("enable", true)) {
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Long titleId = guildInfo.getTitleId();
        if (titleId == null) {
            PlayerTitleUtil.createTitle(guildInfo);
            return;
        }
        boolean isHave = PlayerTitleApi.getInstance().findByTitleId(titleId);
        if (!isHave) {
            PlayerTitleUtil.createTitle(guildInfo);
            return;
        }
        Integer level = guildInfo.getLevel();
        String buffType = ConfigUtil.TITLE_CONFIG.getString("buffType");
        List description = ConfigUtil.TITLE_CONFIG.getStringList("description");
        String title = ConfigUtil.TITLE_CONFIG.getString(level + ".title");
        List buffList = ConfigUtil.TITLE_CONFIG.getStringList(level + ".buff");
        List displayList = ConfigUtil.TITLE_CONFIG.getStringList(level + ".display");
        if (StrUtil.isEmpty(title)) {
            return;
        }
        title = title.replace("${guild_name}", guildInfo.getGuildName());
        PlayerTitleApi.getInstance().update(titleId, title, false);
        PlayerTitleApi.getInstance().updateDescription(titleId, CollUtil.listToStr(description).replace("${guild_name}", guildInfo.getGuildName()));
        PlayerTitleApi.getInstance().removeTitleBuff(titleId);
        PlayerTitleApi.getInstance().addTitleBuff(titleId, PlayerTitleUtil.getTitleBuffList(buffList, buffType, displayList));
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildId);
        for (GuildPlayer guildPlayer : guildPlayerList) {
            PlayerTitleApi.getInstance().set(guildPlayer.getPlayerName(), titleId);
        }
    }

    public static void removeTitle(Long titleId) {
        if (!PlayerGuild.USE_TITLE) {
            return;
        }
        if (titleId == null) {
            return;
        }
        PlayerTitleApi.getInstance().removeTitle(titleId);
    }

    public static void addGuildPlayerTitle(String playerName, Long titleId) {
        if (!PlayerGuild.USE_TITLE) {
            return;
        }
        if (titleId == null) {
            return;
        }
        PlayerTitleApi.getInstance().set(playerName, titleId);
    }

    public static void removeGuildPlayerTitle(String playerName, Long titleId) {
        if (!PlayerGuild.USE_TITLE) {
            return;
        }
        if (titleId == null) {
            return;
        }
        PlayerTitleApi.getInstance().removePlayerTitle(playerName, titleId);
    }

    private static List<TitleBuffParam> getTitleBuffList(List<String> buffList, String buffType, List<String> displayList) {
        ArrayList<TitleBuffParam> titleBuffList = new ArrayList<TitleBuffParam>();
        if (CollUtil.isEmpty(buffList)) {
            return titleBuffList;
        }
        for (int i = 0; i < buffList.size(); ++i) {
            String buff = buffList.get(i);
            if (StrUtil.isEmpty(buff)) continue;
            TitleBuffParam titleBuffParam = new TitleBuffParam();
            titleBuffParam.setBuffType(BuffTypeEnum.getEnum((String)buffType));
            titleBuffParam.setBuffContent(buff);
            if (CollUtil.isNotEmpty(displayList) && displayList.size() >= i + 1) {
                titleBuffParam.setDescription(displayList.get(i));
            }
            titleBuffList.add(titleBuffParam);
        }
        return titleBuffList;
    }
}

