/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.hook;

import com.handy.guild.PlayerGuild;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.hook.WorldEditUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.JsonUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.param.GuildSpawn;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.wimbli.WorldBorder.Config;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WorldUtil {
    private WorldUtil() {
    }

    public static void createWorld(Player player, Integer guildId, String worldName, String alias) {
        if (PlayerGuild.MULTIVERSE_CORE == null) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("multiverseCoreFailureMsg"));
            return;
        }
        if (StrUtil.isEmpty(worldName)) {
            throw new RuntimeException("\u6ca1\u6709\u4e16\u754c\u540d\u5b57");
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        String environment = ConfigUtil.WORLD_CONFIG.getString("environment");
        String worldType = ConfigUtil.WORLD_CONFIG.getString("worldType");
        String seedString = ConfigUtil.WORLD_CONFIG.getString("seedString");
        boolean generateStructures = ConfigUtil.WORLD_CONFIG.getBoolean("generateStructures");
        String difficulty = ConfigUtil.WORLD_CONFIG.getString("difficulty");
        boolean pvpMode = ConfigUtil.WORLD_CONFIG.getBoolean("PVPMode");
        boolean keepSpawnInMemory = ConfigUtil.WORLD_CONFIG.getBoolean("keepSpawnInMemory");
        String customGenerator = ConfigUtil.WORLD_CONFIG.getString("customGenerator");
        MVWorldManager worldManager = PlayerGuild.MULTIVERSE_CORE.getMVWorldManager();
        boolean rst = worldManager.addWorld(worldName, World.Environment.valueOf((String)environment), seedString, WorldType.valueOf((String)worldType), Boolean.valueOf(generateStructures), customGenerator);
        if (!rst) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("multiverseCoreFailureMsg"));
            return;
        }
        MultiverseWorld creativeWorld = worldManager.getMVWorld(worldName);
        creativeWorld.setAlias(alias);
        creativeWorld.setDifficulty(Difficulty.valueOf((String)difficulty));
        creativeWorld.setPVPMode(pvpMode);
        creativeWorld.setKeepSpawnInMemory(keepSpawnInMemory);
        Location spawnLocation = creativeWorld.getSpawnLocation();
        int radiusX = ConfigUtil.WORLD_CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".x");
        int radiusZ = ConfigUtil.WORLD_CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".z");
        WorldUtil.setBorder(worldName, radiusX, radiusZ, spawnLocation.getX(), spawnLocation.getZ());
        WorldUtil.setGameRule(worldName);
        String serverName = ConfigUtil.CONFIG.getString("serverName", "server");
        GuildSpawn guildSpawn = new GuildSpawn();
        guildSpawn.setServerName(serverName);
        guildSpawn.setX(spawnLocation.getX());
        guildSpawn.setY(spawnLocation.getY());
        guildSpawn.setZ(spawnLocation.getZ());
        guildSpawn.setYaw(spawnLocation.getYaw());
        guildSpawn.setPitch(spawnLocation.getPitch());
        guildSpawn.setWorld(Objects.requireNonNull(spawnLocation.getWorld()).getName());
        String guildSpawnLocation = JsonUtil.toJson(guildSpawn);
        GuildInfoService.getInstance().updateSpawnLocation(guildId, guildSpawnLocation, worldName);
        PlayerSchedulerUtil.teleport((Entity)player, GuildUtil.getLocation(guildSpawn));
        MessageUtil.sendTitle(player, guildInfo.getGuildName(), BaseUtil.getLangMsg("welcomeTitle").replace("${player}", player.getName()));
        if (PlayerGuild.USE_WORLD_EDIT && ConfigUtil.WORLD_EDIT_CONFIG.getBoolean("enable", true)) {
            WorldEditUtil.create(spawnLocation);
        }
    }

    public static Location getSpawnLocation(String worldName) {
        MVWorldManager worldManager = PlayerGuild.MULTIVERSE_CORE.getMVWorldManager();
        MultiverseWorld world = worldManager.getMVWorld(worldName);
        return world.getSpawnLocation();
    }

    public static void removeWorld(String worldName, List<String> playerNameList) {
        if (PlayerGuild.MULTIVERSE_CORE == null) {
            return;
        }
        if (StrUtil.isEmpty(worldName)) {
            return;
        }
        HandySchedulerUtil.runTask(() -> {
            for (String playerName : playerNameList) {
                WorldUtil.removePlayerFromWorld(playerName, worldName);
            }
            PlayerGuild.MULTIVERSE_CORE.deleteWorld(worldName);
        });
    }

    public static void removePlayerFromWorld(String playerName, String worldName) {
        if (PlayerGuild.MULTIVERSE_CORE == null) {
            return;
        }
        if (StrUtil.isEmpty(worldName)) {
            return;
        }
        Optional<Player> playerOptional = BaseUtil.getOnlinePlayer(playerName);
        if (playerOptional.isPresent() && playerOptional.get().getWorld().getName().equals(worldName)) {
            playerOptional.get().performCommand("spawn");
        }
    }

    public static void setGuildBorder(GuildInfo guildInfo) {
        if (PlayerGuild.MULTIVERSE_CORE == null) {
            return;
        }
        String worldName = guildInfo.getWorldName();
        if (StrUtil.isEmpty(worldName)) {
            return;
        }
        MVWorldManager worldManager = PlayerGuild.MULTIVERSE_CORE.getMVWorldManager();
        MultiverseWorld creativeWorld = worldManager.getMVWorld(worldName);
        if (creativeWorld == null) {
            return;
        }
        Location spawnLocation = creativeWorld.getSpawnLocation();
        int radiusX = ConfigUtil.WORLD_CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".x");
        int radiusZ = ConfigUtil.WORLD_CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".z");
        if (radiusX == 0 || radiusZ == 0) {
            MessageUtil.sendConsoleDebugMessage("&a\u8d85\u8fc7\u7b49\u7ea7\u4e0a\u9650\uff0c\u9ed8\u8ba4\u4e0d\u8bbe\u7f6e");
            return;
        }
        HandySchedulerUtil.runTask(() -> WorldUtil.setBorder(worldName, radiusX, radiusZ, spawnLocation.getX(), spawnLocation.getZ()));
    }

    private static void setBorder(String worldName, int radiusX, int radiusZ, double x, double z) {
        String borderType = ConfigUtil.WORLD_CONFIG.getString("borderType", "WorldBorder");
        if ("WorldBorder".equalsIgnoreCase(borderType) && PlayerGuild.USE_WORLD_BORDER) {
            Config.setBorder((String)worldName, (int)radiusX, (int)radiusZ, (double)x, (double)z, (Boolean)false);
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            MessageUtil.sendConsoleMessage("\u8bbe\u7f6e\u8fb9\u5883\u5931\u8d25,\u516c\u4f1a\u4e16\u754c\u4e0d\u5b58\u5728:" + worldName);
            return;
        }
        world.getWorldBorder().setCenter(world.getSpawnLocation());
        world.getWorldBorder().setSize((double)radiusX);
    }

    public static void setGameRule(String worldName) {
        List gameRuleFalseFlag;
        if (StrUtil.isEmpty(worldName)) {
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return;
        }
        List gameRuleTrueFlag = ConfigUtil.WORLD_CONFIG.getStringList("gameRule.trueFlag");
        if (CollUtil.isNotEmpty(gameRuleTrueFlag)) {
            for (String gameRule : gameRuleTrueFlag) {
                if (!StrUtil.isNotEmpty(gameRule)) continue;
                world.setGameRuleValue(gameRule, "true");
            }
        }
        if (CollUtil.isNotEmpty(gameRuleFalseFlag = ConfigUtil.WORLD_CONFIG.getStringList("gameRule.falseFlag"))) {
            for (String gameRule : gameRuleFalseFlag) {
                if (!StrUtil.isNotEmpty(gameRule)) continue;
                world.setGameRuleValue(gameRule, "false");
            }
        }
    }

    public static void setWorldAlias(String worldName, String guildName) {
        if (StrUtil.isEmpty(worldName)) {
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return;
        }
        MVWorldManager worldManager = PlayerGuild.MULTIVERSE_CORE.getMVWorldManager();
        MultiverseWorld creativeWorld = worldManager.getMVWorld(worldName);
        if (creativeWorld == null) {
            return;
        }
        String aliasName = ConfigUtil.WORLD_CONFIG.getString("aliasName", "${guildName}").replace("${guildName}", guildName);
        creativeWorld.setAlias(aliasName);
    }
}

