/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildSortEnum;
import com.handy.guild.enter.GuildApply;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPvpLog;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPvpLogService;
import com.handy.guild.service.GuildPvpService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuildOpenGui {
    private static final GuildOpenGui INSTANCE = new GuildOpenGui();

    private GuildOpenGui() {
    }

    public static GuildOpenGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, String sortName) {
        String title = ConfigUtil.OPEN_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.OPEN_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_OPEN.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(sortName);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_OPEN.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildInfo> page = GuildInfoService.getInstance().page(handyInventory.getPageNum(), handyInventory.getPageSize(), handyInventory.getSearchType());
        handyInventory.setPageCount(page.getTotal());
        List<GuildInfo> records = page.getRecords();
        if (CollUtil.isEmpty(records)) {
            return;
        }
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findRoleByGuildInfoIds(records.stream().map(GuildInfo::getId).collect(Collectors.toList()));
        Map<Integer, GuildPlayer> guildPlayerMap = guildPlayerList.stream().collect(Collectors.groupingBy(GuildPlayer::getGuildInfoId, Collectors.collectingAndThen(Collectors.toList(), value -> (GuildPlayer)value.get(0))));
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        GuildApply guildApply = null;
        if (!guildPlayerOptional.isPresent()) {
            guildApply = GuildApplyService.getInstance().findByPlayerName(player.getName(), ApplyTypeEnum.PENDING.getId()).orElse(null);
        }
        String name = ConfigUtil.OPEN_CONFIG.getString("guild.name");
        boolean isEnchant = ConfigUtil.OPEN_CONFIG.getBoolean("guild.isEnchant");
        name = StrUtil.isNotEmpty(name) ? name : "";
        List loreList = ConfigUtil.OPEN_CONFIG.getStringList("guild.lore");
        LinkedHashMap<Integer, ItemStack> itemStackMap = new LinkedHashMap<Integer, ItemStack>();
        for (GuildInfo guildInfo : records) {
            List<String> newLoreList = new ArrayList<String>();
            String guildName = name.replace("${guild_name}", BaseUtil.replaceChatColor(guildInfo.getGuildName()));
            Map<String, String> replaceMap = this.replaceMap(guildInfo, guildApply, guildPlayerOptional.orElse(null), guildPlayerMap);
            for (String lore : loreList) {
                for (String str : replaceMap.keySet()) {
                    lore = lore.replace("${" + str + "}", replaceMap.get(str));
                }
                newLoreList.add(lore);
            }
            newLoreList = ItemStackUtil.loreBatchReplaceMap(newLoreList, GuildUtil.getDescriptionMap(guildInfo.getDescription()), null);
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(guildInfo.getLogoName());
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(guildName));
            itemMeta.setLore(BaseUtil.replaceChatColor(newLoreList));
            if (isEnchant) {
                ItemStackUtil.setEnchant(itemMeta);
            }
            ItemStackUtil.hideAttributes(itemMeta);
            ItemStackUtil.hideEnchant(itemMeta);
            itemStack.setItemMeta(itemMeta);
            itemStackMap.put(guildInfo.getId(), itemStack);
        }
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (Integer guildId : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(guildId));
            map.put(index, guildId);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "info");
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (guildPlayerOptional.isPresent()) {
            boolean memberEnable = ConfigUtil.OPEN_CONFIG.getBoolean("me.enable");
            if (memberEnable) {
                HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "me");
                map.put(ConfigUtil.OPEN_CONFIG.getInt("me.index", 49), guildPlayerOptional.get().getGuildInfoId());
            }
        } else if (player.hasPermission("playerGuild.create")) {
            HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "create");
        }
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "search", this.replaceSearchMap(handyInventory));
        HandyInventoryUtil.setCustomButton(ConfigUtil.OPEN_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> replaceSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        GuildSortEnum guildSortEnum = GuildSortEnum.getEnum(searchType);
        GuildSortEnum nextEnum = GuildSortEnum.getNextEnum(searchType);
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", GuildSortEnum.getTypeName(guildSortEnum));
        map.put("nextType", GuildSortEnum.getTypeName(nextEnum));
        return map;
    }

    private Map<String, String> replaceMap(GuildInfo guildInfo, GuildApply guildApply, GuildPlayer guildPlayer, Map<Integer, GuildPlayer> guildPlayerMap) {
        Optional<GuildPvpLog> guildPvpLogOptional;
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(13);
        replaceMap.put("prosperity_degree", guildInfo.getProsperityDegree().toString());
        replaceMap.put("month_prosperity_degree", guildInfo.getMonthProsperityDegree().toString());
        replaceMap.put("guild_name", BaseUtil.replaceChatColor(guildInfo.getGuildName()));
        GuildPlayer errorGuildPlayer = new GuildPlayer();
        errorGuildPlayer.setPlayerName("\u5f02\u5e38\u516c\u4f1a");
        replaceMap.put("guild_owner", guildPlayerMap.getOrDefault(guildInfo.getId(), errorGuildPlayer).getPlayerName());
        replaceMap.put("guild_creator", guildInfo.getCreator());
        replaceMap.put("guild_money", guildInfo.getMoney().toString());
        replaceMap.put("guild_level", guildInfo.getLevel().toString());
        replaceMap.put("guild_member_count", guildInfo.getMemberCount().toString());
        replaceMap.put("guild_max_member_count", guildInfo.getMemberMaxCount().toString());
        replaceMap.put("guild_creation_time", DateUtil.format(guildInfo.getCreateTime(), "yyyy-MM-dd"));
        String joinModeButton = ConfigUtil.SETTING_CONFIG.getString("joinMode.apply");
        if (guildInfo.getJoinMode() != null && !guildInfo.getJoinMode().booleanValue()) {
            joinModeButton = ConfigUtil.SETTING_CONFIG.getString("joinMode.auto");
        }
        replaceMap.put("join_mode", joinModeButton);
        String view = ConfigUtil.OPEN_CONFIG.getString("view");
        String noView = ConfigUtil.OPEN_CONFIG.getString("noView");
        String apply = ConfigUtil.OPEN_CONFIG.getString("apply");
        String button = ConfigUtil.OPEN_CONFIG.getString("join");
        if (guildApply != null && guildApply.getGuildInfoId().equals(guildInfo.getId())) {
            button = apply;
        } else if (guildPlayer != null) {
            button = guildPlayer.getGuildInfoId().equals(guildInfo.getId()) ? view : noView;
        }
        replaceMap.put("button", button);
        String guildSeasonRank = "0";
        Integer season = GuildPvpService.getInstance().findSeason();
        if (season > 1) {
            season = season - 1;
        }
        if ((guildPvpLogOptional = GuildPvpLogService.getInstance().findRankBySeason(guildInfo.getId(), season)).isPresent()) {
            guildSeasonRank = guildPvpLogOptional.get().getRank().toString();
        }
        replaceMap.put("guild_season_rank", guildSeasonRank);
        return replaceMap;
    }
}

