/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildTask;
import com.handy.guild.enter.GuildTaskDemand;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildTaskDemandService;
import com.handy.guild.service.GuildTaskService;
import com.handy.guild.util.ConfigUtil;
import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.util.TaskUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildTaskGui {
    private static final GuildTaskGui INSTANCE = new GuildTaskGui();

    private GuildTaskGui() {
    }

    public static GuildTaskGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.TASK_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.TASK_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_TASK.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_TASK.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildTask> page = GuildTaskService.getInstance().page(handyInventory.getId(), handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildTask> records = page.getRecords();
        List<Integer> guildTaskIdList = records.stream().map(GuildTask::getId).collect(Collectors.toList());
        List<GuildTaskDemand> guildTaskDemands = GuildTaskDemandService.getInstance().findByGuildTaskIds(guildTaskIdList);
        Map<Integer, List<GuildTaskDemand>> guildTaskDemandMap = guildTaskDemands.stream().collect(Collectors.groupingBy(GuildTaskDemand::getGuildTaskId));
        for (GuildTask record : records) {
            if (guildTaskDemandMap.get(record.getId()) == null) continue;
            record.setGuildTaskDemandList(guildTaskDemandMap.get(record.getId()));
        }
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (GuildTask record : records) {
            Integer index = guiIndexList.get(i++);
            ArrayList<TaskPlayerDemand> taskDemands = new ArrayList<TaskPlayerDemand>();
            for (GuildTaskDemand guildTaskDemand : record.getGuildTaskDemandList()) {
                TaskPlayerDemand taskPlayerDemand = new TaskPlayerDemand();
                taskPlayerDemand.setType(guildTaskDemand.getType());
                taskPlayerDemand.setCompletionAmount(guildTaskDemand.getCompletionAmount());
                taskPlayerDemand.setAmount(guildTaskDemand.getAmount());
                taskPlayerDemand.setItemStack(guildTaskDemand.getItemStack());
                taskDemands.add(taskPlayerDemand);
            }
            String material = ConfigUtil.TASK_CONFIG.getString("guildTask." + record.getTaskId() + ".material");
            String name = ConfigUtil.TASK_CONFIG.getString("guildTask." + record.getTaskId() + ".name", "${taskName}").replace("${taskName}", record.getTaskName());
            int customModelData = ConfigUtil.TASK_CONFIG.getInt("guildTask." + record.getTaskId() + ".custom-model-data");
            List loreList = ConfigUtil.TASK_CONFIG.getStringList("guildTask." + record.getTaskId() + ".lore");
            HashMap<String, List<String>> replaceMap = MapUtil.of("taskSchedule", TaskUtil.taskScheduleReplaceMap(taskDemands));
            List<String> newLoreList = ItemStackUtil.loreBatchReplaceMap(loreList, replaceMap, "");
            ItemStack itemStack = ItemStackUtil.getItemStack(material, name, newLoreList, false, customModelData);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, record.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        HandyInventoryUtil.setButton(ConfigUtil.TASK_CONFIG, inventory, "info");
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.TASK_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.TASK_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.TASK_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.TASK_CONFIG, inventory, "pane");
    }
}

