/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.event.GuildDissolutionEvent;
import com.handy.guild.hook.PlayerChatUtil;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.hook.WorldUtil;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.BuffManageUtil;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@HandyListener
public class GuildDissolutionEventListener
implements Listener {
    @EventHandler
    public void onGuildDissolutionEvent(GuildDissolutionEvent event) {
        Integer guildId = event.getGuildId();
        List<GuildPlayer> guildPlayers = GuildPlayerService.getInstance().findByGuildId(guildId);
        ArrayList<String> playerNameList = new ArrayList<String>();
        for (GuildPlayer guildPlayer : guildPlayers) {
            GuildConstants.PLAYER_GUILD_MAP.remove(UUID.fromString(guildPlayer.getPlayerUuid()));
            playerNameList.add(guildPlayer.getPlayerName());
            Optional<Player> playerOptional = BaseUtil.getOnlinePlayer(guildPlayer.getPlayerName());
            playerOptional.ifPresent(player -> BuffManageUtil.removeBuff(player));
            MessageUtil.sendMessage(guildPlayer.getPlayerName(), ConfigUtil.CONFIRM_CONFIG.getString("dissolutionMsg"));
            Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(UUID.fromString(guildPlayer.getPlayerUuid()));
            if (!onlinePlayerOpt.isPresent()) continue;
            Player onlinePlayer = onlinePlayerOpt.get();
            PlayerChatUtil.unRegPlayerChannel(onlinePlayer, guildId);
            PlayerChatUtil.setPlayerChannelToDefault(onlinePlayer);
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        PlayerTitleUtil.removeTitle(guildInfo.getTitleId());
        WorldUtil.removeWorld(guildInfo.getWorldName(), playerNameList);
        GuildInfoService.getInstance().delByGuildId(guildId);
        PlayerChatUtil.unRegChannel(guildId);
    }
}

