/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.api.PlayerGuildApi;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;

@HandyListener
public class InventoryClickEventListener
implements Listener {
    @EventHandler
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!InventoryType.CRAFTING.equals((Object)event.getView().getType())) {
            return;
        }
        if (!InventoryType.SlotType.CRAFTING.equals((Object)event.getSlotType())) {
            return;
        }
        Optional<Player> playerOptional = HandyInventoryUtil.getPlayer(event);
        if (!playerOptional.isPresent()) {
            return;
        }
        Player player = playerOptional.get();
        if (!PlayerGuildApi.getInstance().isPvp(player)) {
            return;
        }
        event.setCancelled(true);
        player.closeInventory();
        MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("playerCraftingMsg"));
    }
}

