/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.event.GuildDissolutionEvent;
import com.handy.guild.inventory.GuildManageMemberGui;
import com.handy.guild.inventory.GuildSettingGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class ConfirmClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.CONFIRM.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        String type;
        int rawSlot = event.getRawSlot();
        switch (type = handyInventory.getSearchType()) {
            case "dissolution": {
                this.dissolution(handyInventory, rawSlot);
                break;
            }
            case "up": {
                this.up(handyInventory, rawSlot);
                break;
            }
            case "exit": {
                this.exit(handyInventory, rawSlot);
                break;
            }
        }
    }

    private void dissolution(HandyInventory handyInventory, int rawSlot) {
        Player player = handyInventory.getPlayer();
        Integer guildId = handyInventory.getId();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "back")) {
            Inventory inventory = GuildSettingGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "cancel")) {
            Inventory inventory = GuildSettingGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "confirm")) {
            handyInventory.syncClose();
            HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildDissolutionEvent(player, guildId)));
        }
    }

    private void up(HandyInventory handyInventory, int rawSlot) {
        Player player = handyInventory.getPlayer();
        Integer guildPlayerId = Integer.valueOf(handyInventory.getObj().toString());
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "back")) {
            Inventory inventory = GuildManageMemberGui.getInstance().createGui(player, handyInventory.getId(), guildPlayerId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "cancel")) {
            Inventory inventory = GuildManageMemberGui.getInstance().createGui(player, handyInventory.getId(), guildPlayerId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "confirm")) {
            Optional<GuildPlayer> clickGuildPlayerOpt = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!clickGuildPlayerOpt.isPresent()) {
                return;
            }
            ConfirmClickEvent.upRole(guildPlayerId, clickGuildPlayerOpt.get().getId());
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
        }
    }

    public static void upRole(Integer guildPlayerId, Integer clickGuildPlayerId) {
        GuildPlayer oldGuildPlayer;
        UUID oldUuid;
        Optional<GuildPlayer> oldGuildPlayerOpt;
        GuildPlayer newGuildPlayer;
        UUID newUuid;
        GuildPlayerService.getInstance().updateRoleIdById(guildPlayerId, GuildRoleEnum.ONE.getRoleId());
        GuildPlayerService.getInstance().updateRoleIdById(clickGuildPlayerId, GuildRoleEnum.TWO.getRoleId());
        Optional<GuildPlayer> newGuildPlayerOpt = GuildPlayerService.getInstance().findById(guildPlayerId);
        if (newGuildPlayerOpt.isPresent() && GuildConstants.PLAYER_GUILD_MAP.containsKey(newUuid = UUID.fromString((newGuildPlayer = newGuildPlayerOpt.get()).getPlayerUuid()))) {
            GuildConstants.PLAYER_GUILD_MAP.put(newUuid, newGuildPlayer);
        }
        if ((oldGuildPlayerOpt = GuildPlayerService.getInstance().findById(clickGuildPlayerId)).isPresent() && GuildConstants.PLAYER_GUILD_MAP.containsKey(oldUuid = UUID.fromString((oldGuildPlayer = oldGuildPlayerOpt.get()).getPlayerUuid()))) {
            GuildConstants.PLAYER_GUILD_MAP.put(oldUuid, oldGuildPlayer);
        }
    }

    private void exit(HandyInventory handyInventory, int rawSlot) {
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "cancel")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CONFIRM_CONFIG, "confirm")) {
            handyInventory.syncClose();
            PlayerSchedulerUtil.syncPerformCommand(player, "plg leave");
        }
    }
}

