/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPvp;
import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.inventory.GuildActivityGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPvpLocationService;
import com.handy.guild.service.GuildPvpLogService;
import com.handy.guild.service.GuildPvpService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildActivityClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_ACTIVITY.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Integer guildId = handyInventory.getId();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ACTIVITY_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, guildId);
            handyInventory.syncOpen(inventory);
            return;
        }
        int startDate = ConfigUtil.ACTIVITY_CONFIG.getInt("seasonPvp.startDate");
        Integer todayWeek = DateUtil.dayOfWeekEnum(new Date());
        if (todayWeek == startDate && ConfigUtil.ACTIVITY_CONFIG.getBoolean("seasonPvp.enable")) {
            MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("stopMsg"));
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ACTIVITY_CONFIG, "seasonPvp")) {
            Optional<GuildPvp> guildPvpOptional = GuildPvpService.getInstance().findByGuildInfoId(guildId);
            if (!guildPvpOptional.isPresent()) {
                GuildPvp guildPvp = new GuildPvp();
                guildPvp.setSeason(GuildPvpService.getInstance().findSeason());
                guildPvp.setGuildInfoId(guildId);
                guildPvp.setIsJoin(true);
                guildPvp.setIsStart(false);
                GuildPvpService.getInstance().add(guildPvp);
            } else {
                GuildPvp guildPvp = guildPvpOptional.get();
                GuildPvpService.getInstance().updateJoinById(guildPvp.getId(), guildPvp.getIsJoin() == false);
            }
            GuildActivityGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ACTIVITY_CONFIG, "matePvp")) {
            long keepAlive;
            int waitTime = ConfigUtil.ACTIVITY_CONFIG.getInt("matePvpClick");
            if (GuildConstants.MATE_PVP_CLICK_WAIT_TIME.containsKey(player.getUniqueId()) && (keepAlive = (System.currentTimeMillis() - GuildConstants.MATE_PVP_CLICK_WAIT_TIME.get(player.getUniqueId())) / 1000L) < (long)waitTime) {
                String waitTimeMsg = ConfigUtil.ACTIVITY_CONFIG.getString("matePvpClickMsg", "").replace("${time}", (long)waitTime - keepAlive + "");
                MessageUtil.sendMessage(player, waitTimeMsg);
                return;
            }
            GuildConstants.MATE_PVP_CLICK_WAIT_TIME.put(player.getUniqueId(), System.currentTimeMillis());
            List<GuildPvpLocation> records = GuildPvpLocationService.getInstance().findByType(GuildActivityType.MATCH.getType());
            if (CollUtil.isEmpty(records)) {
                MessageUtil.sendMessage(player, ConfigUtil.PVP_LOCATION_CONFIG.getString("noLocation"));
                return;
            }
            HashSet<Integer> haveNameSet = new HashSet<Integer>();
            for (Integer mapGuildId : MatchConstants.GUILD_PVP_START_LOCATION_MAP.keySet()) {
                haveNameSet.add(MatchConstants.GUILD_PVP_START_LOCATION_MAP.get(mapGuildId));
            }
            if (records.size() == haveNameSet.size()) {
                MessageUtil.sendMessage(player, ConfigUtil.PVP_LOCATION_CONFIG.getString("noUseLocation"));
                return;
            }
            int count = GuildPvpLogService.getInstance().findByGuildInfoIdAndStartTime(guildId, DateUtil.getToday());
            boolean unlimited = ConfigUtil.ACTIVITY_CONFIG.getBoolean("matePvp.unlimited");
            if (count >= ConfigUtil.ACTIVITY_CONFIG.getInt("matePvp.number") && !unlimited) {
                MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("mateLimitMsg"));
                return;
            }
            if (MatchConstants.GUILD_PVP_PREPARATION_MAP.get(guildId) != null || MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId) != null) {
                String matePvpAcceptPrepareMsg = ConfigUtil.ACTIVITY_CONFIG.getString("matePvpAcceptPrepareMsg");
                MessageUtil.sendMessage(player, matePvpAcceptPrepareMsg);
                return;
            }
            Integer time = MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.get(guildId);
            if (time != null) {
                MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.remove(guildId);
                GuildActivityGui.getInstance().setInventoryDate(handyInventory);
                return;
            }
            GuildUtil.callGuildPvpMatchEvent(player, guildId, handyInventory);
        }
    }
}

