/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.ShopBuyLimitTypeEnum;
import com.handy.guild.constants.ShopSearchEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildShop;
import com.handy.guild.enter.GuildShopLog;
import com.handy.guild.inventory.GuildShopGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildShopLogService;
import com.handy.guild.service.GuildShopService;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildShopClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_SHOP.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "search")) {
            String type = null;
            if (ShopSearchEnum.ALL.getType().equals(handyInventory.getSearchType())) {
                type = ShopSearchEnum.SYSTEM.getType();
            }
            if (ShopSearchEnum.SYSTEM.getType().equals(handyInventory.getSearchType())) {
                type = ShopSearchEnum.PLAYER.getType();
            }
            if (ShopSearchEnum.PLAYER.getType().equals(handyInventory.getSearchType())) {
                type = ShopSearchEnum.ALL.getType();
            }
            Inventory inventory = GuildShopGui.getInstance().createGui(player, handyInventory.getId(), type);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "sell")) {
            GuildConstants.CREATE_GUILD_INFO_MAP.put(player.getUniqueId(), "sell");
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellMsg"));
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                GuildShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                GuildShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        Integer id = map.get(rawSlot);
        if (id == null) {
            return;
        }
        GuildShopClickEvent.buy(id, player, handyInventory);
    }

    private static synchronized void buy(Integer id, Player player, HandyInventory handyInventory) {
        Optional<GuildShop> guildShopOptional = GuildShopService.getInstance().findById(id);
        if (!guildShopOptional.isPresent()) {
            GuildShopGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        GuildShop guildShop = guildShopOptional.get();
        if (StrUtil.isNotEmpty(guildShop.getPlayerName()) && player.getName().equals(guildShop.getPlayerName())) {
            GuildShopService.getInstance().delById(guildShop.getId());
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(guildShop.getItemStack());
            ItemStackUtil.addItem(player.getInventory(), itemStack, guildShop.getNumber());
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("noSellMsg"));
            GuildShopGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(handyInventory.getId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (guildShop.getLevel() > guildInfo.getLevel()) {
            String levelButton = ConfigUtil.SHOP_CONFIG.getString("levelButton", "${level}").replace("${level}", guildShop.getLevel().toString());
            MessageUtil.sendMessage(player, levelButton);
            return;
        }
        if (guildPlayer.getMoney() < guildShop.getPrice()) {
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("noButton"));
            return;
        }
        if (GuildShopClickEvent.buyLimit(guildShop, guildInfo, player)) {
            String noLimitButton = ConfigUtil.SHOP_CONFIG.getString("noLimitButton", "");
            ShopBuyLimitTypeEnum enumDefaultOnly = ShopBuyLimitTypeEnum.getEnumDefaultOnly(guildShop.getType());
            MessageUtil.sendMessage(player, noLimitButton.replace("${buyType}", ShopBuyLimitTypeEnum.getTypeName(enumDefaultOnly)));
            return;
        }
        GuildPlayerService.getInstance().subtractMoneyById(guildPlayer.getId(), guildShop.getPrice());
        ItemStack itemStack = ItemStackUtil.itemStackDeserialize(guildShop.getItemStack());
        ItemStackUtil.addItem(player.getInventory(), itemStack, itemStack.getAmount());
        MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("buyMsg"));
        if (StrUtil.isNotEmpty(guildShop.getPlayerName())) {
            if (guildShop.getNumber() - 1 > 0) {
                GuildShopService.getInstance().subtractNumberById(guildShop.getId(), 1);
            } else {
                GuildShopService.getInstance().delById(guildShop.getId());
            }
            GuildPlayerService.getInstance().addMoneyByName(guildShop.getPlayerName(), guildShop.getPrice());
            String sellBuyMsg = ConfigUtil.SHOP_CONFIG.getString("sellBuyMsg", "");
            sellBuyMsg = sellBuyMsg.replace("${player}", guildPlayer.getPlayerName()).replace("${item}", BaseUtil.getDisplayName(itemStack)).replace("${money}", guildShop.getPrice().toString());
            MessageUtil.sendMessage(guildShop.getPlayerName(), sellBuyMsg);
        }
        GuildShopGui.getInstance().setInventoryDate(handyInventory);
    }

    private static boolean buyLimit(GuildShop guildShop, GuildInfo guildInfo, Player player) {
        if (guildShop.getNumber() == 0 || StrUtil.isNotEmpty(guildShop.getPlayerName())) {
            return false;
        }
        ShopBuyLimitTypeEnum typeEnum = ShopBuyLimitTypeEnum.getEnumDefaultOnly(guildShop.getType());
        switch (typeEnum) {
            case ONLY: {
                Optional<GuildShopLog> guildShopLogOptional = GuildShopLogService.getInstance().findByPlayerName(player.getName(), typeEnum.getName(), guildShop.getId());
                if (guildShopLogOptional.isPresent()) {
                    GuildShopLog guildShopLog = guildShopLogOptional.get();
                    if (guildShop.getNumber() <= guildShopLog.getNumber()) {
                        return true;
                    }
                    GuildShopLogService.getInstance().addNumber(guildShopLog.getId(), 1);
                    break;
                }
                GuildShopLog guildShopLog = new GuildShopLog();
                guildShopLog.setGuildInfoId(guildInfo.getId());
                guildShopLog.setGuildInfoName(guildInfo.getGuildName());
                guildShopLog.setPlayerName(player.getName());
                guildShopLog.setPlayerUuid(player.getUniqueId().toString());
                guildShopLog.setGuildShopId(guildShop.getId());
                guildShopLog.setNumber(1);
                guildShopLog.setType(typeEnum.getName());
                guildShopLog.setBuyTime(new Date());
                GuildShopLogService.getInstance().add(guildShopLog);
                break;
            }
            case DAY: {
                if (!GuildShopClickEvent.checkCount(guildShop, guildInfo, player, typeEnum, DateUtil.getToday(), DateUtil.getTodayEnd())) break;
                return true;
            }
            case WEEK: {
                if (GuildShopClickEvent.checkCount(guildShop, guildInfo, player, typeEnum, DateUtil.getMonday(), DateUtil.getSunday())) {
                    return true;
                }
            }
            case MONTH: {
                if (!GuildShopClickEvent.checkCount(guildShop, guildInfo, player, typeEnum, DateUtil.getFirstDayOfMonth(), DateUtil.getLastDayOfMonth())) break;
                return true;
            }
        }
        return false;
    }

    private static boolean checkCount(GuildShop guildShop, GuildInfo guildInfo, Player player, ShopBuyLimitTypeEnum typeEnum, Date startTime, Date endTime) {
        Integer dayCount = GuildShopLogService.getInstance().findCountByPlayerName(player.getName(), typeEnum.getName(), guildShop.getId(), startTime, endTime);
        if (guildShop.getNumber() <= dayCount) {
            return true;
        }
        GuildShopLog guildShopLog = new GuildShopLog();
        guildShopLog.setGuildInfoId(guildInfo.getId());
        guildShopLog.setGuildInfoName(guildInfo.getGuildName());
        guildShopLog.setPlayerName(player.getName());
        guildShopLog.setPlayerUuid(player.getUniqueId().toString());
        guildShopLog.setGuildShopId(guildShop.getId());
        guildShopLog.setNumber(1);
        guildShopLog.setType(typeEnum.getName());
        guildShopLog.setBuyTime(new Date());
        GuildShopLogService.getInstance().add(guildShopLog);
        return false;
    }
}

