/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPlayerSignIn;
import com.handy.guild.hook.PlayerPointsUtil;
import com.handy.guild.hook.VaultUtil;
import com.handy.guild.inventory.GuildSignInGui;
import com.handy.guild.inventory.GuildViewGui;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.HandyPermissionUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPlayerSignInService;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class GuildSignInClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_SIGN_IN.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SIGN_IN_CONFIG, "back")) {
            Inventory inventory = GuildViewGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        GuildSignInClickEvent.signIn(handyInventory, rawSlot);
    }

    private static synchronized void signIn(HandyInventory handyInventory, int rawSlot) {
        Player player = handyInventory.getPlayer();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildPlayerSignIn> guildPlayerSignInOptional = GuildPlayerSignInService.getInstance().findByPlayerName(player.getName());
        if (guildPlayerSignInOptional.isPresent()) {
            MessageUtil.sendMessage(player, ConfigUtil.SIGN_IN_CONFIG.getString("signedInButton"));
            return;
        }
        int money = 0;
        boolean rst = false;
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SIGN_IN_CONFIG, "point")) {
            int pointPrice = ConfigUtil.SIGN_IN_CONFIG.getInt("point.price");
            rst = PlayerPointsUtil.buy(player, pointPrice);
            money = ConfigUtil.SIGN_IN_CONFIG.getInt("point.money");
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SIGN_IN_CONFIG, "vault")) {
            int vaultPrice = ConfigUtil.SIGN_IN_CONFIG.getInt("vault.price");
            rst = VaultUtil.buy(player, vaultPrice);
            money = ConfigUtil.SIGN_IN_CONFIG.getInt("vault.money");
        }
        if (!rst) {
            MessageUtil.sendMessage(player, ConfigUtil.SIGN_IN_CONFIG.getString("notMoneyFailureMsg"));
            return;
        }
        GuildPlayerSignIn signIn = new GuildPlayerSignIn();
        signIn.setGuildInfoId(guildPlayer.getGuildInfoId());
        signIn.setPlayerName(player.getName());
        signIn.setPlayerUuid(player.getUniqueId().toString());
        signIn.setSignInTime(new Date());
        int signInId = GuildPlayerSignInService.getInstance().add(signIn);
        if (signInId > 0) {
            Double vip = HandyPermissionUtil.getDoubleNumber(player, ConfigUtil.SIGN_IN_CONFIG, "signIn");
            money = (int)((double)money * vip);
            String succeedMsg = ConfigUtil.SIGN_IN_CONFIG.getString("succeedMsg", "").replace("${money}", money + "");
            MessageUtil.sendMessage(player, succeedMsg);
            GuildPlayerService.getInstance().addMoneyById(guildPlayer.getId(), money);
            GuildSignInGui.getInstance().setInventoryDate(handyInventory);
        } else {
            MessageUtil.sendMessage(player, ConfigUtil.SIGN_IN_CONFIG.getString("failureMsg"));
        }
    }
}

