/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildPlayerPickaxe;
import com.handy.guild.lib.db.Db;
import java.util.List;

public class GuildPlayerPickaxeService {
    private GuildPlayerPickaxeService() {
    }

    public static GuildPlayerPickaxeService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildPlayerPickaxe enter) {
        Db.use(GuildPlayerPickaxe.class).execution().insert(enter);
    }

    public List<GuildPlayerPickaxe> findByPlayerName(String playerName) {
        Db<GuildPlayerPickaxe> use = Db.use(GuildPlayerPickaxe.class);
        use.where().eq(GuildPlayerPickaxe::getPlayerName, playerName);
        return use.execution().list();
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildPlayerPickaxe> use = Db.use(GuildPlayerPickaxe.class);
        use.where().eq(GuildPlayerPickaxe::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildPlayerPickaxe> findAll() {
        return Db.use(GuildPlayerPickaxe.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildPlayerPickaxeService INSTANCE = new GuildPlayerPickaxeService();

        private SingletonHolder() {
        }
    }
}

