/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.service.GuildSpawnPvpLocationService;
import java.util.List;
import java.util.Optional;

public class GuildPvpLocationService {
    private GuildPvpLocationService() {
    }

    public static GuildPvpLocationService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildPvpLocation guildPvpLocation) {
        return Db.use(GuildPvpLocation.class).execution().insert(guildPvpLocation);
    }

    public Optional<GuildPvpLocation> findById(Integer id) {
        return Db.use(GuildPvpLocation.class).execution().selectById(id);
    }

    public Optional<GuildPvpLocation> findByNameAndType(String name, String type) {
        Db<GuildPvpLocation> db = Db.use(GuildPvpLocation.class);
        db.where().eq(GuildPvpLocation::getName, name).ge(GuildPvpLocation::getType, type);
        return db.execution().selectOne();
    }

    public Page<GuildPvpLocation> page(String type, Integer pageNum, Integer pageSize) {
        Db<GuildPvpLocation> db = Db.use(GuildPvpLocation.class);
        db.where().eq(StrUtil.isNotEmpty(type), GuildPvpLocation::getType, type).orderByDesc(GuildPvpLocation::getId).limit(pageNum, pageSize);
        return db.execution().page();
    }

    public List<GuildPvpLocation> listByNotIds(String type, List<Integer> ids) {
        Db<GuildPvpLocation> db = Db.use(GuildPvpLocation.class);
        db.where().eq(GuildPvpLocation::getType, type).notIn(CollUtil.isNotEmpty(ids), GuildPvpLocation::getId, ids);
        return db.execution().list();
    }

    public List<GuildPvpLocation> findByType(String type) {
        Db<GuildPvpLocation> use = Db.use(GuildPvpLocation.class);
        use.where().eq(GuildPvpLocation::getType, type);
        return use.execution().list();
    }

    public void delById(Integer id) {
        Db.use(GuildPvpLocation.class).execution().deleteById(id);
        GuildSpawnPvpLocationService.getInstance().delByGuildPvpLocationId(id);
    }

    public Optional<GuildPvpLocation> findById(String name) {
        Db<GuildPvpLocation> db = Db.use(GuildPvpLocation.class);
        db.where().eq(GuildPvpLocation::getName, name);
        return db.execution().selectOne();
    }

    public List<GuildPvpLocation> findAll() {
        return Db.use(GuildPvpLocation.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildPvpLocationService INSTANCE = new GuildPvpLocationService();

        private SingletonHolder() {
        }
    }
}

