/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.enter.GuildPvpLog;
import com.handy.guild.lib.db.Db;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class GuildPvpLogService {
    private GuildPvpLogService() {
    }

    public static GuildPvpLogService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildPvpLog guildPvpLog) {
        return Db.use(GuildPvpLog.class).execution().insert(guildPvpLog);
    }

    public Optional<GuildPvpLog> findById(Integer id) {
        return Db.use(GuildPvpLog.class).execution().selectById(id);
    }

    public int updateById(Integer id, boolean result) {
        Db<GuildPvpLog> db = Db.use(GuildPvpLog.class);
        db.update().set(GuildPvpLog::getResult, result);
        return db.execution().updateById(id);
    }

    public Optional<GuildPvpLog> findRankBySeason(Integer guildInfoId, Integer season) {
        Db<GuildPvpLog> db = Db.use(GuildPvpLog.class);
        db.where().eq(GuildPvpLog::getGuildInfoId, guildInfoId).eq(GuildPvpLog::getType, GuildActivityType.SEASON.getType()).eq(GuildPvpLog::getSeason, season);
        return db.execution().selectOne();
    }

    public int findByGuildInfoIdAndStartTime(Integer guildInfoId, Date date) {
        Db<GuildPvpLog> db = Db.use(GuildPvpLog.class);
        db.where().eq(GuildPvpLog::getGuildInfoId, guildInfoId).ge(GuildPvpLog::getStartTime, date);
        return db.execution().count();
    }

    public List<GuildPvpLog> findAll() {
        return Db.use(GuildPvpLog.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildPvpLogService INSTANCE = new GuildPvpLogService();

        private SingletonHolder() {
        }
    }
}

