/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.util;

import com.handy.guild.PlayerGuild;
import com.handy.guild.enter.GuildEquipment;
import com.handy.guild.lib.constants.VersionCheckEnum;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.util.BuffManageUtil;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.LeatherUtil;
import com.handy.playerrace.api.PlayerRaceApi;
import com.handy.playertitle.api.PlayerTitleApi;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

public class KitPvpUtil {
    public static final Map<UUID, Double> GUILD_PVP_START_PLAYER_HEALTH_MAP = new ConcurrentHashMap<UUID, Double>();

    private KitPvpUtil() {
    }

    public static void kitPvp(Player player) {
        KitPvpUtil.sendCommand(player);
        KitPvpUtil.banFly(player);
        KitPvpUtil.removePlayerTitleBuff(player);
        KitPvpUtil.removePlayerRaceBuff(player);
        KitPvpUtil.removePotionEffectBuff(player);
        KitPvpUtil.removeGuildTitleBuff(player);
        KitPvpUtil.setMaxHealth(player);
        KitPvpUtil.setHealth(player);
        KitPvpUtil.removeAdapt(player);
    }

    public static void setMaxHealth(Player player) {
        if (!ConfigUtil.KIT_PVP_CONFIG.getBoolean("maxHealth.enable", false)) {
            return;
        }
        GUILD_PVP_START_PLAYER_HEALTH_MAP.put(player.getUniqueId(), player.getMaxHealth());
        double health = ConfigUtil.KIT_PVP_CONFIG.getDouble("maxHealth.health", 20.0);
        player.setMaxHealth(health);
    }

    public static void setHealth(Player player) {
        player.setHealth(player.getMaxHealth());
    }

    public static void equipment(Player player, Color color, List<GuildEquipment> equipmentList) {
        if (ConfigUtil.KIT_PVP_CONFIG.getBoolean("equipment", false) && VersionCheckEnum.getEnum().getVersionId() > VersionCheckEnum.V_1_8.getVersionId()) {
            LeatherUtil.setPlayerLeatherItemStack(player, color, equipmentList);
        }
    }

    private static void sendCommand(Player player) {
        List commandList = ConfigUtil.KIT_PVP_CONFIG.getStringList("performCommand.command");
        if (CollUtil.isEmpty(commandList)) {
            return;
        }
        if (!ConfigUtil.KIT_PVP_CONFIG.getBoolean("performCommand.enable", false)) {
            return;
        }
        for (String command : commandList) {
            if ((command = command.replace("${player}", player.getName())).contains("[Console]")) {
                String trimCommand = command.replace("[Console]", "").trim();
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)trimCommand);
                continue;
            }
            player.performCommand(command);
        }
    }

    private static void banFly(Player player) {
        if (!ConfigUtil.KIT_PVP_CONFIG.getBoolean("banFly", false)) {
            return;
        }
        player.setAllowFlight(false);
    }

    private static void removePlayerTitleBuff(Player player) {
        if (PlayerGuild.USE_TITLE && ConfigUtil.KIT_PVP_CONFIG.getBoolean("playerTitleBuff", true)) {
            PlayerTitleApi.getInstance().removeBuff(player);
            MessageUtil.sendMessage(player, ConfigUtil.KIT_PVP_CONFIG.getString("playerTitleBuffOffMsg"));
        }
    }

    private static void removeGuildTitleBuff(Player player) {
        BuffManageUtil.removeBuff(player);
    }

    private static void removePlayerRaceBuff(Player player) {
        if (PlayerGuild.USE_RACE && ConfigUtil.KIT_PVP_CONFIG.getBoolean("playerRaceBuff", true)) {
            PlayerRaceApi.getInstance().temporaryCancel(player);
            MessageUtil.sendMessage(player, ConfigUtil.KIT_PVP_CONFIG.getString("playerRaceBuffOffMsg"));
        }
    }

    private static void removePotionEffectBuff(Player player) {
        if (!ConfigUtil.KIT_PVP_CONFIG.getBoolean("potionEffectBuff", true)) {
            return;
        }
        Collection activePotionEffects = player.getActivePotionEffects();
        if (CollUtil.isNotEmpty(activePotionEffects)) {
            for (PotionEffect potionEffect : activePotionEffects) {
                player.removePotionEffect(potionEffect.getType());
            }
            MessageUtil.sendMessage(player, ConfigUtil.KIT_PVP_CONFIG.getString("potionEffectBuffOnMsg"));
        }
    }

    private static void removeAdapt(Player player) {
        if (PlayerGuild.USE_ADAPT && ConfigUtil.KIT_PVP_CONFIG.getBoolean("adapt", false)) {
            MessageUtil.sendMessage(player, ConfigUtil.KIT_PVP_CONFIG.getString("adaptOffMsg"));
        }
    }
}

