/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask;

import com.handy.playertask.hook.PlaceholderUtil;
import com.handy.playertask.lib.InitApi;
import com.handy.playertask.lib.core.SignUtil;
import com.handy.playertask.lib.db.SqlManagerUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.mm.MythicMobUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.listener.NpcClickEventListener;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.TaskJob;
import com.handy.playertask.util.UpUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.milkbowl.vault.economy.Economy;
import org.black_ixx.playerpoints.PlayerPoints;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerTask
extends JavaPlugin {
    private static PlayerTask INSTANCE;
    private static Economy ECON;
    private static PlayerPoints PLAYER_POINTS;
    public static boolean CITIZENS;
    public static boolean USE_PAPI;

    public void onEnable() {
        INSTANCE = this;
        SignUtil.SignConstants.FAILURE_MSG = Collections.singletonList(ChatColor.GREEN + "\u60a8\u6b63\u5728\u4f7f\u7528" + this.getName() + "\u63d2\u4ef6\u514d\u8d39\u7248,\u611f\u8c22\u60a8\u7684\u652f\u6301");
        InitApi initApi = InitApi.getInstance(this);
        ConfigUtil.init();
        this.loadEconomy();
        this.loadPlaceholder();
        this.loadPlayerPoints();
        this.loadMythicMobs();
        CITIZENS = BaseUtil.hook("Citizens", "CitizensSucceedMsg", "CitizensFailureMsg");
        List<String> lordList = Arrays.asList("", "  ____  _                      _____         _    ", " |  _ \\| | __ _ _   _  ___ _ _|_   _|_ _ ___| | __", " | |_) | |/ _` | | | |/ _ \\ '__|| |/ _` / __| |/ /", " |  __/| | (_| | |_| |  __/ |   | | (_| \\__ \\   < ", " |_|   |_|\\__,_|\\__, |\\___|_|   |_|\\__,_|___/_|\\_\\", "                |___/                             ");
        for (String lord : lordList) {
            MessageUtil.sendConsoleMessage(ChatColor.DARK_AQUA + lord);
        }
        TaskJob.getInstance().setAsyncTodayTask();
        ArrayList<String> classList = new ArrayList<String>();
        if (!CITIZENS) {
            classList.add(NpcClickEventListener.class.getName());
        }
        initApi.checkVersion(ConfigUtil.CONFIG.getBoolean("isCheckUpdate"), "https://api.github.com/repos/handy-git/PlayerTaskVersions/releases/latest").enableSql("com.handy.playertask.entity").initCommand("com.handy.playertask.command").initClickEvent("com.handy.playertask.listener.gui").initListener("com.handy.playertask.listener", classList).enableBc().addMetrics(8144);
        UpUtil.up();
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u5df2\u6210\u529f\u8f7d\u5165\u670d\u52a1\u5668\uff01");
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "Author:handy MCBBS: https://www.mcbbs.net/thread-1084534-1-1.html");
    }

    public void onDisable() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            InventoryView openInventory = onlinePlayer.getOpenInventory();
            InventoryHolder holder = openInventory.getTopInventory().getHolder();
            if (!(holder instanceof HandyInventory)) continue;
            onlinePlayer.closeInventory();
        }
        SqlManagerUtil.getInstance().close();
    }

    public static PlayerTask getInstance() {
        return INSTANCE;
    }

    public static Economy getEconomy() {
        return ECON;
    }

    public static PlayerPoints getPlayerPoints() {
        return PLAYER_POINTS;
    }

    public void loadEconomy() {
        RegisteredServiceProvider rsp;
        boolean hook = BaseUtil.hook("Vault", "vaultSucceedMsg", "vaultFailureMsg");
        if (hook && (rsp = this.getServer().getServicesManager().getRegistration(Economy.class)) != null) {
            ECON = (Economy)rsp.getProvider();
        }
    }

    public void loadPlaceholder() {
        USE_PAPI = BaseUtil.hook("PlaceholderAPI", "placeholderAPISucceedMsg", "placeholderAPIFailureMsg");
        if (USE_PAPI) {
            new PlaceholderUtil(this).register();
        }
    }

    private void loadPlayerPoints() {
        boolean hook = BaseUtil.hook("PlayerPoints", "playerPointsSucceedMsg", "playerPointsFailureMsg");
        if (hook) {
            Optional<Plugin> pluginOpt = BaseUtil.hook("PlayerPoints");
            PLAYER_POINTS = pluginOpt.orElse(null);
        }
    }

    private void loadMythicMobs() {
        boolean hook = BaseUtil.hook("MythicMobs", "MythicMobsSucceedMsg", "MythicMobsFailureMsg");
        if (hook) {
            MythicMobUtil.init((Plugin)this);
        }
    }

    static {
        ECON = null;
        PLAYER_POINTS = null;
    }
}

